/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/wvcm/src/org/apache/wvcm/store/webdav/response/ErrorResponse.java,v 1.3 2004/07/30 06:52:30 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:30 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */

package org.apache.wvcm.store.webdav.response;

import java.io.InputStream;
import javax.wvcm.WvcmException;
import javax.wvcm.WvcmException.ReasonCode;
import org.apache.wvcm.ProviderImpl;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;

/**
 * Handler for error response bodies.
 *
 * @author <a href="mailto:peter.nevermann@softwareag.com">Peter Nevermann</a>
 * @version $Revision: 1.3 $
 */
public class ErrorResponse {
    
    private static Namespace dnsp = Namespace.getNamespace("d", "DAV:");
    private Document respBodyDoc;
    
    /**
     * Create handler from given input stream.
     */
    public ErrorResponse( InputStream respBodyAsStream ) throws WvcmException {
        try {
            this.respBodyDoc = ProviderImpl.getSAXBuilder().build( respBodyAsStream );
        }
        catch( Exception e ) {
            this.respBodyDoc = null;
            // We cannot rely on 403, 409 responses always returning a DAV:error element
//            throw new WvcmException( "Could not parse server response",
//                                    null, WvcmException.READ_FAILED, new Exception[]{e} );
        }
    }
    
    public ReasonCode getWvcmReasonCode() {
        ReasonCode result = ReasonCode.FORBIDDEN;
        if( respBodyDoc != null ) {
            Element er = respBodyDoc.getRootElement();
            if( er != null && er.getChildren() != null && er.getChildren().size() > 0 ) {
                Element cd = (Element)er.getChildren().get(0);
                result = ReasonCode.getReasonCodeForRFC3253Condition( cd.getName() );
                if( result == null ) {
                    new Exception("Missing reason code for condition ("+cd.getName()+")").printStackTrace();
                    result = ReasonCode.CONFLICT;
                }
            }
        }
        return result;
    }
}

