/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/wvcm/src/org/apache/wvcm/store/webdav/response/LockTokenFactory.java,v 1.3 2004/07/30 06:52:30 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:30 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */

package org.apache.wvcm.store.webdav.response;
import javax.wvcm.LockToken;
import javax.wvcm.Principal;
import javax.wvcm.Provider;
import javax.wvcm.Resource;
import javax.wvcm.WvcmException;
import org.apache.wvcm.LocationImpl;
import org.apache.wvcm.LockTokenImpl;
import org.apache.wvcm.PrincipalImpl;
import org.jdom.Element;
import org.jdom.Namespace;

/**
 * Creates LockToken instances out of XML DAV:lockdiscovery response elements.
 *
 * @author <a href="mailto:peter.nevermann@softwareag.com">Peter Nevermann</a>
 * @version $Revision: 1.3 $
 */
public class LockTokenFactory {
    
    private static Namespace dnsp = Namespace.getNamespace("d", "DAV:");
    
    private Resource requestResource;
    private Provider provider;
    
    public LockTokenFactory(Resource requestResource, Provider provider) {
        this.requestResource = requestResource;
        this.provider = provider;
    }
    
    public LockToken create(Element activelockElm) throws WvcmException {
        LockToken result = null;
        String lockId = null;
        LockToken.Scope lockScope = LockToken.Scope.EXCLUSIVE;
        LockToken.Depth depth = LockToken.Depth.INFINITY;
        Principal owner = null;
        String ownerInfo = "";
        LockToken.Timeout timeout = LockToken.Timeout.INFINITE;
        
        Element ltElm = activelockElm.getChild("locktoken", dnsp);
        if (ltElm != null) {
            Element hrefElm = ltElm.getChild("href", dnsp);
            if (hrefElm != null) {
                lockId = hrefElm.getTextTrim();
            }
        }
        
        Element purlElm = activelockElm.getChild("principal-URL", dnsp);
        if (purlElm != null) {
            Element hrefElm = purlElm.getChild("href", dnsp);
            if (hrefElm != null) {
                LocationImpl loc = (LocationImpl)provider.location(hrefElm.getTextTrim());
                owner = (Principal)loc.resource(PrincipalImpl.class);
            }
        }
        
        Element lsElm = activelockElm.getChild("lockscope", dnsp);
        if (lsElm != null) {
            Element sharedElm = lsElm.getChild("shared", dnsp);
            if (sharedElm != null) {
                lockScope = LockToken.Scope.SHARED;
            }
        }
        
        Element dElm = activelockElm.getChild("depth", dnsp);
        if (dElm != null) {
            if ("0".equals(dElm.getTextTrim())) {
                depth = LockToken.Depth.ZERO;
            }
        }
        
        Element oElm = activelockElm.getChild("owner", dnsp);
        if (oElm != null) {
            Element hrefElm = oElm.getChild("href", dnsp);
            if (hrefElm != null) {
                ownerInfo = hrefElm.getTextTrim();
            }
            else {
                ownerInfo = oElm.getText();
            }
        }
        
        Element toElm = activelockElm.getChild("timeout", dnsp);
        if (toElm != null) {
            String tout = toElm.getTextTrim();
            if (tout != null && tout.startsWith("Second-")) {
                try {
                    int toutInt = Integer.parseInt(tout.substring(7));
                    if (toutInt < (0.75 * Integer.MAX_VALUE)) {
                        timeout = new LockToken.Timeout(toutInt);
                    }
                }
                catch (NumberFormatException e) {
                    // TODO: ???
                }
            }
        }
        
        result = new LockTokenImpl(lockId, lockScope, depth, owner, ownerInfo, timeout);
        return result;
    }
}


