/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/wvcm/src/org/apache/wvcm/util/PropertyNameLists.java,v 1.8 2004/07/30 06:52:31 ozeigermann Exp $
 * $Revision: 1.8 $
 * $Date: 2004/07/30 06:52:31 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */

package org.apache.wvcm.util;

import java.lang.reflect.Field;
import javax.wvcm.PropertyNameList;
import javax.wvcm.PropertyNameList.AttributeName;
import javax.wvcm.PropertyNameList.NestedPropertyName;
import javax.wvcm.PropertyNameList.PropertyName;


/**
 * WebDAV-based implementation of Accessor.
 *
 * @author <a href="mailto:peter.nevermann@softwareag.com">Peter Nevermann</a>
 * @version $Revision: 1.8 $
 */
public class PropertyNameLists {
    
    static public boolean contains(PropertyNameList pnameList, String name) {
        return propertyName(pnameList, name) != null;
    }
    
    static public boolean contains(PropertyNameList pnameList, String name, String namespace) {
        return propertyName(pnameList, name, namespace) != null;
    }
    
    static public PropertyName propertyName(PropertyNameList pnameList, String name) {
        if( name != null && pnameList != null && pnameList.getPropertyNames() != null ) {
            int n = pnameList.getPropertyNames().length;
            for( int i = 0; i < n; i++ ) {
                PropertyName pname = pnameList.getPropertyNames()[i];
                PropertyName pn = pname;
                if (pn instanceof NestedPropertyName) {
                    pn = ((NestedPropertyName)pn).getName();
                }
                
                if (pn instanceof AttributeName && "DAV:".equals(((AttributeName)pn).getNamespace())) {
                    if (name.equals(pn.getString())) {
                        return pname;
                    }
                }
                else if (name.equals(pn.getString())) {
                    return pname;
                }
            }
        }
        return null;
    }
    
    static public PropertyName propertyName(PropertyNameList pnameList, String name, String namespace) {
        if( name != null && namespace != null && pnameList != null && pnameList.getPropertyNames() != null ) {
            int n = pnameList.getPropertyNames().length;
            for( int i = 0; i < n; i++ ) {
                PropertyName pname = pnameList.getPropertyNames()[i];
                PropertyName pn = pname;
                if (pn instanceof NestedPropertyName) {
                    pn = ((NestedPropertyName)pn).getName();
                }
                
                if (pn instanceof AttributeName && namespace.equals(((AttributeName)pn).getNamespace())) {
                    if (name.equals(pn.getString())) {
                        return pname;
                    }
                }
                else if (name.equals(pn.getString()) && "DAV:".equals(namespace)) {
                    return pname;
                }
            }
        }
        return null;
    }
    
    /**
     * Find the PropertyName instance for the specified string.
     *
     * @param    name the PropertyName string
     * @return   a PropertyName (null if string does not specify a property)
     *
     */
    public static PropertyName propertyName( String name ) {
        Field[] fields = PropertyName.class.getDeclaredFields();
        PropertyName result = null;
        
        if( name != null ) {
            for( int i = 0; i < fields.length; i++ ) {
                PropertyName p;
                try {
                    p = (PropertyName)fields[i].get(null);
                }
                catch (IllegalAccessException e) {
                    continue;
                }
                if( name.equals(p.getString()) ) {
                    result = p;
                    break;
                }
            }
        }
        return result;
    }
    
    static public boolean isAllAttributes( PropertyNameList pnameList ) {
        return( pnameList != null && pnameList.getPropertyNames() != null
                   && pnameList.getPropertyNames().length == 1
                   && pnameList.getPropertyNames()[0] == PropertyName.ALL_ATTRIBUTES );
    }
    
    static public PropertyNameList extractAllAttributes( PropertyNameList pnameList ) {
        if( pnameList != null && pnameList.getPropertyNames() != null ) {
            PropertyName[] pnames = pnameList.getPropertyNames();
            for( int i = 0; i < pnames.length; i++ ) {
                if( PropertyName.ALL_ATTRIBUTES == pnames[i] ) {
                    return new PropertyNameList(
                        new PropertyName[]{PropertyName.ALL_ATTRIBUTES}
                    );
                }
            }
        }
        return null;
    }
}

