/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/wvcm/src/org/apache/wvcm/util/XPathWrapper.java,v 1.3 2003/12/08 17:14:28 pnever Exp $
 * $Revision: 1.3 $
 * $Date: 2003/12/08 17:14:28 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */

package org.apache.wvcm.util;

import java.util.List;
import javax.wvcm.WvcmException;
import javax.wvcm.WvcmException.ReasonCode;
import org.jaxen.JaxenException;
import org.jaxen.XPath;
import org.jaxen.jdom.JDOMXPath;
import org.jdom.Namespace;

// jdom_b9:
//import org.jdom.xpath.*;

public class XPathWrapper {
    
    XPath xp;
    
    /**
     * Constructor
     *
     * @param    expression          a  String
     *
     */
    public XPathWrapper(String expression, Namespace nsp) throws WvcmException {
        // jdom_b8:
        try {
            this.xp = new JDOMXPath(expression);
            this.xp.addNamespace(nsp.getPrefix(), nsp.getURI());
        }
        catch (JaxenException e) {
            throw new WvcmException( "Could not create XPath", null, ReasonCode.CONFLICT, new Exception[]{e} );
        }

        // jdom_b9:
//      try {
//          this.xp = XPath.newInstance(expression);
//          this.xp.addNamespace(nsp);
//      }
//      catch (JdomException e) {
//          throw new WvcmException( "Could not create XPath", null, ReasonCode.CONFLICT, new Exception[]{e} );
//      }
    }
    
    /**
     * Evaluates the wrapped XPath expression and returns the list of selected nodes.
     *
     * @param    context the node to use as context for evaluating the XPath expression.
     *
     * @return   the list of selected nodes, which can be instances of the following JDOM classes:
     *           Element, Attribute, Text, CDATA, Comment or ProcessingInstruction.
     *
     * @throws   WvcmException
     *
     */
    public List selectNodes( Object context ) throws WvcmException {
        try {
            return xp.selectNodes( context );
        }
        // jdom_b8
        catch (JaxenException e) {
            throw new WvcmException( "Evaluation of xpath expression "+xp+" failed", null, ReasonCode.READ_FAILED, new Exception[]{e} );
        }
        // jdom_b9
//        catch (JdomException e) {
//            throw new WvcmException( "Evaluation of xpath expression "+xp+" failed", null, ReasonCode.READ_FAILED, new Exception[]{e} );
//        }
    }
    
    /**
     * Evaluates the wrapped XPath expression and returns the first entry in the list of selected nodes.
     *
     * @param    context the node to use as context for evaluating the XPath expression.
     *
     * @return   the first selected nodes, which is an instance of one of the following JDOM classes:
     *           Element, Attribute, Text, CDATA, Comment or ProcessingInstruction
     *           or null if no node was selected.
     *
     * @throws   WvcmException
     *
     */
    public Object selectSingleNode( Object context ) throws WvcmException {
        try {
            return xp.selectSingleNode( context );
        }
        // jdom_b8
        catch (JaxenException e) {
            throw new WvcmException( "Evaluation of xpath expression "+xp+" failed", null, ReasonCode.READ_FAILED, new Exception[]{e} );
        }
        // jdom_b9
//        catch (JdomException e) {
//            throw new WvcmException( "Evaluation of xpath expression "+xp+" failed", null, ReasonCode.READ_FAILED, new Exception[]{e} );
//        }
    }
}
