/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/wvcm/test/junit/src/org/apache/webdav/methods/AbstractTest.java,v 1.14 2004/07/30 06:52:31 ozeigermann Exp $
 * $Revision: 1.14 $
 * $Date: 2004/07/30 06:52:31 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */

package org.apache.webdav.methods;

import java.util.Properties;
import junit.framework.TestCase;
import org.apache.commons.httpclient.*;

/**
 * This testsuite depends upon a running WebDAV server.
 * The environment can be set-up by setting properties at
 * test.properties.
 *
 * @author <a href="mailto:peter.nevermann@softwareag.com">Peter Nevermann</a>
 * @version $Revision: 1.14 $
 */
public abstract class AbstractTest extends TestCase {
    
    protected static Properties webdavprops = new Properties();
    static {
        try {
            webdavprops.load( AbstractTest.class.getResourceAsStream("/test.properties") );
        } catch (java.io.IOException e) {}
    }
    
    protected String host = null;
    protected int port = 0;
    protected String context = null;
    protected String rootfolder = null;
    protected String realm = null;
    protected String username = null;
    protected String password = null;

    protected HttpClient client = null;
        
    // caches
    private String contextPath = null;
    private String rootFolderPath = null;
    
    
    /**
     * Default constructor
     */
    public AbstractTest(String testName) {
        super(testName);
        host = webdavprops.getProperty( "org.apache.webdav.test.host", "localhost" );
        String portStr = webdavprops.getProperty( "org.apache.webdav.test.port", "8080" );
        try {
            port = Integer.parseInt(portStr);
        }
        catch (NumberFormatException e) {
            port = 8080;
        }
        context = webdavprops.getProperty( "org.apache.webdav.test.context", "slide" );
        rootfolder = webdavprops.getProperty( "org.apache.webdav.test.rootfolder", "files" );
        realm = webdavprops.getProperty( "org.apache.webdav.test.realm", null );
        username = webdavprops.getProperty( "org.apache.webdav.test.username", "root" );
        password = webdavprops.getProperty( "org.apache.webdav.test.password", "root" );
        
        client = new HttpClient();
        client.getHostConfiguration().setHost(host, port, "http");
        HttpState state = new HttpState();
        state.setCredentials(
            realm, host, new UsernamePasswordCredentials(username, password) );
        client.setState( state );
    }
    
    /**
     *
     */
    protected void setUp() throws Exception {
        super.setUp ();
    }
    
    /**
     * Tears down the fixture, for example, close a network connection.
     * This method is called after a test is executed.
     */
    protected void tearDown() throws Exception {
    }
    
    protected void deleteResourceOnServer( String resourcePath ) throws Exception {
        HttpMethod method = new DeleteMethod( resourcePath );
        client.executeMethod( method );
        assertTrue( method.getStatusCode() == 204 || method.getStatusCode() == 404 );
    }
    
    protected boolean resourceExistsOnServer( String resourcePath ) throws Exception {
        HttpMethod method = new HeadMethod( resourcePath );
        client.executeMethod( method );
        return( method.getStatusCode() == 200 );
    }
    
    /**
     * Get context path
     *
     * @return   a String
     */
    protected synchronized String contextPath() {
        if( contextPath == null ) {
            if( context != null && context.length() > 0 )
                contextPath = "/"+context;
            else
                contextPath = "/";
        }
        return contextPath;
    }
    
    /**
     * Get rootfolder path
     *
     * @return   a String
     */
    protected synchronized String rootFolderPath() {
        if( rootFolderPath == null ) {
            if( rootfolder != null && rootfolder.length() > 0 )
                rootFolderPath = contextPath()+"/"+rootfolder;
            else
                rootFolderPath = contextPath();
        }
        return rootFolderPath;
    }
}
