/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/wvcm/test/junit/src/org/apache/webdav/methods/PropfindMethodTest.java,v 1.15 2004/12/03 14:28:01 pnever Exp $
 * $Revision: 1.15 $
 * $Date: 2004/12/03 14:28:01 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */

package org.apache.webdav.methods;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.jdom.*;
import org.jdom.input.*;
import org.jdom.output.*;
import org.apache.wvcm.util.*;


/**
 * Tests PropfindMethod.
 *
 * @author <a href="mailto:peter.nevermann@softwareag.com">Peter Nevermann</a>
 * @version $Revision: 1.15 $
 */
public class PropfindMethodTest extends AbstractTest {
    
    private String resourcePath = null;
    
    /**
     * Default cosntructor
     */
    public PropfindMethodTest(String testName) {
        super(testName);
        resourcePath = rootFolderPath()+"/test.xml";
    }
    
    /**
     * Method suite
     *
     * @return   a Test
     */
    public static Test suite() {
        return new TestSuite(PropfindMethodTest.class);
    }
    
    /**
     * Start precisely this test suite with the commandline interface.
     *
     * @param args   commandline options (none are evaluated)
     */
    public static void main( String[] args ) {
        junit.textui.TestRunner.run( suite() );
    }
    
    /**
     *
     */
    protected void setUp() throws Exception {
        super.setUp ();
    }
    
    /**
     * Tears down the fixture, for example, close a network connection.
     * This method is called after a test is executed.
     */
    protected void tearDown() throws Exception {
    }
    
    public void testPropfindDisplayname() throws Exception {
        deleteResourceOnServer( resourcePath );
        PutMethod putMethod = new PutMethod( resourcePath );
        putMethod.setRequestBody(
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?><test>Hello</test>" );
        putMethod.addRequestHeader( "Content-Type", "text/xml; charset=\"utf-8\"" );
        client.executeMethod( putMethod );
        assertEquals( 201, putMethod.getStatusCode() );
        
        PropfindMethod pfindMethod = new PropfindMethod( resourcePath );
        Namespace davNsp = Namespace.getNamespace( "d", "DAV:" );
        Element pfindElm = new Element( "propfind", davNsp );
        Element propElm = new Element( "prop", davNsp );
        pfindElm.addContent( propElm );
        Element dnameElm = new Element( "getcontenttype", davNsp );
        propElm.addContent( dnameElm );
        Document pfindBody = new Document( pfindElm );
        Format ft = Format.getPrettyFormat().setEncoding("UTF-8");
        pfindMethod.setRequestBody(
            new XMLOutputter(ft).outputString(pfindBody) );
        client.executeMethod( pfindMethod );
        assertEquals( 207, pfindMethod.getStatusCode() );
        Document mstatusBody =
            new SAXBuilder().build(pfindMethod.getResponseBodyAsStream());
        new XMLOutputter(ft).output( mstatusBody, System.out );
        Element mstatusElm = mstatusBody.getRootElement();
        XPathWrapper xpath = new XPathWrapper(
            // "/d:multistatus/d:response[/d:href=\""+resourcePath+"\"]/d:propstat/d:prop/d:displayname" );
            "/d:multistatus/d:response/d:propstat/d:prop/d:getcontenttype", davNsp );
        
        assertEquals( "text/xml; charset=\"utf-8\"", ((Element)xpath.selectSingleNode(mstatusElm)).getText() );
    }
}
