/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/wvcm/test/junit/src/org/apache/wvcm/store/webdav/PropertiesTest.java,v 1.11 2004/07/30 06:52:32 ozeigermann Exp $
 * $Revision: 1.11 $
 * $Date: 2004/07/30 06:52:32 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */

package org.apache.wvcm.store.webdav;

import junit.framework.Test;
import junit.framework.TestSuite;
import javax.wvcm.*;
import javax.wvcm.PropertyNameList.*;


/**
 * Tests Properties.
 *
 * @author <a href="mailto:peter.nevermann@softwareag.com">Peter Nevermann</a>
 * @version $Revision: 1.11 $
 */
public class PropertiesTest extends org.apache.webdav.methods.AbstractTest {
    
    private StringBuffer webdav;
    private StringBuffer nonwebdav;
    
    /**
     * Default cosntructor
     */
    public PropertiesTest(String testName) throws Exception {
        super(testName);
    }
    
    /**
     * Method suite
     *
     * @return   a Test
     */
    public static Test suite() {
        return new TestSuite(PropertiesTest.class);
    }
    
    /**
     * Start precisely this test suite with the commandline interface.
     *
     * @param args   commandline options (none are evaluated)
     */
    public static void main( String[] args ) {
        junit.textui.TestRunner.run( suite() );
    }
    
    /**
     *
     */
    protected void setUp() throws Exception {
        super.setUp ();
    }
    
    /**
     * Tears down the fixture, for example, close a network connection.
     * This method is called after a test is executed.
     */
    protected void tearDown() throws Exception {
    }
    
    public void testWebdavMapping() throws Exception {
        this.webdav = new StringBuffer();
        this.nonwebdav = new StringBuffer();
        webdav.append("\nProperties which can be mapped to WebDAV names\n");
//        int l = webdav.length();
//        webdav.append("WVCM");
//        webdav.setLength(l+40);
//        webdav.append("WebDAV");
        nonwebdav.append("\nProperties which cannot be mapped to WebDAV names\n");
        printPropMapping(PropertyName.ACTIVITY_CHECKOUT_LIST);
        printPropMapping(PropertyName.ACTIVITY_FOLDER_LIST);
        printPropMapping(PropertyName.ACTIVITY_LIST);
        printPropMapping(PropertyName.ACTIVITY_VERSION_LIST);
        printPropMapping(PropertyName.AUTO_MERGE_LIST);
        printPropMapping(PropertyName.BASELINE_CONTROLLABLE);
        printPropMapping(PropertyName.BASELINE_CONTROLLED_FOLDER_LIST);
        printPropMapping(PropertyName.BASELINE_FOLDER);
        printPropMapping(PropertyName.BINDING_LIST);
        printPropMapping(PropertyName.CHECKED_IN);
        printPropMapping(PropertyName.CHECKED_OUT);
        printPropMapping(PropertyName.CHECKIN_FORK);
        printPropMapping(PropertyName.CHECKOUT_FORK);
        printPropMapping(PropertyName.CHECKOUT_LIST);
        printPropMapping(PropertyName.COMMENT);
        printPropMapping(PropertyName.CONTENT_CHARACTER_SET);
        printPropMapping(PropertyName.CONTENT_IDENTIFIER);
        printPropMapping(PropertyName.CONTENT_LANGUAGE);
        printPropMapping(PropertyName.CONTENT_LENGTH);
        printPropMapping(PropertyName.CONTENT_TYPE);
        printPropMapping(PropertyName.CREATION_DATE);
        printPropMapping(PropertyName.CREATOR_DISPLAY_NAME);
        printPropMapping(PropertyName.CURRENT_ACTIVITY_LIST);
        printPropMapping(PropertyName.CURRENT_WORKSPACE_LIST);
        printPropMapping(PropertyName.DIRTY_PROPERTY_LIST);
        printPropMapping(PropertyName.DISPLAY_NAME);
        printPropMapping(PropertyName.ECLIPSED_LIST);
        printPropMapping(PropertyName.IS_CHECKED_OUT);
        printPropMapping(PropertyName.IS_DIRTY_CONTENT);
        printPropMapping(PropertyName.IS_STALE_CONTENT);
        printPropMapping(PropertyName.LABEL_NAME_LIST);
        printPropMapping(PropertyName.LAST_MODIFIED);
        printPropMapping(PropertyName.MERGE_LIST);
        printPropMapping(PropertyName.PARENT_BINDING_LIST);
        printPropMapping(PropertyName.PREDECESSOR_LIST);
        printPropMapping(PropertyName.PROVIDER_LIST);
        printPropMapping(PropertyName.RESOURCE_IDENTIFIER);
        printPropMapping(PropertyName.ROOT_FOLDER);
        printPropMapping(PropertyName.ROOT_VERSION);
        printPropMapping(PropertyName.SERVER_STATE);
        printPropMapping(PropertyName.STALE_PROPERTY_LIST);
        printPropMapping(PropertyName.SUBACTIVITY_LIST);
        printPropMapping(PropertyName.SUBBASELINE_LIST);
        printPropMapping(PropertyName.SUCCESSOR_LIST);
        printPropMapping(PropertyName.UNRESERVED);
        printPropMapping(PropertyName.VERSION_BY_LABEL_FOLDER);
        printPropMapping(PropertyName.VERSION_CONTROLLABLE);
        printPropMapping(PropertyName.VERSION_CONTROLLED_CONFIGURATION);
        printPropMapping(PropertyName.VERSION_HISTORY);
        printPropMapping(PropertyName.VERSION_HISTORY_FOLDER_LIST);
        printPropMapping(PropertyName.VERSION_NAME);
        printPropMapping(PropertyName.WORKSPACE);
        printPropMapping(PropertyName.WORKSPACE_CHECKOUT_LIST);
        printPropMapping(PropertyName.WORKSPACE_FOLDER_LIST);
        System.out.println(webdav.toString().replace('\u0000',' '));
        System.out.println(nonwebdav);
    }
    
    private void printPropMapping(PropertyName pname) {
        String webdavname = WebdavProperties.webdavNameForPropertyName(pname);
        if( webdavname != null ) {
            if( webdav.length() > 0 )
                webdav.append("\n");
            int l = webdav.length();
            webdav.append(pname.getString());
            webdav.setLength(l+40);
            webdav.append(webdavname);
        }
        else {
            if( nonwebdav.length() > 0 )
                nonwebdav.append("\n");
            nonwebdav.append(pname.getString());
        }
    }
}

