/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/wvcm/test/junit/src/org/apache/wvcm/test/ControllableFolderTest.java,v 1.3 2004/07/30 06:52:32 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:32 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */

package org.apache.wvcm.test;

import java.util.logging.Logger;
import java.util.Iterator;
import java.util.List;


import javax.wvcm.ControllableFolder;
import javax.wvcm.WvcmException;
import javax.wvcm.WvcmException.ReasonCode;
import javax.wvcm.PropertyNameList;
import javax.wvcm.PropertyNameList.PropertyName;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.apache.wvcm.test.common.AbstractTest;
import org.apache.wvcm.test.common.util.ReasonCodeChecker;


/**
 * Provides functional tests for the ControllableFolder interface.
 *
 * @author <a href="mailto:peter.nevermann@softwareag.com">Peter Nevermann</a>
 * @version $Revision: 1.3 $
 */
public class ControllableFolderTest extends AbstractTest {
    
	private String testFolderFoo = "foo";
	private String testFolderBar = "bar";
	private String testFileName1 = "1.xml";
	private String testFileName2 = "2.xml";
	private String testFileName3 = "3.xml";
	private int numberOfCreatedResources = 0;
	
	// logger
	private static Logger logger = Logger.getLogger("org.apache.wvcm.test.ControllableFolderTest");
    
    /**
	 * Default Constructor
	 *
	 * @param    testName            Name of the test to run.
	 *
	 * @throws   Exception
	 *
	 */
    public ControllableFolderTest(String testName) throws Exception {
		super(testName);
		folderPath = rootFolderPath() + "/" + testFolderFoo;
    }
    
    /**
	 * Method suite
	 *
	 * @return   a Test
	 */
    public static Test suite() {
		return new TestSuite(ControllableFolderTest.class);
    }
    
    /**
	 * Start test suite contained in this class using the text interface. If a
	 * parameter is passed, it will use it as a test name and run only that test
	 * case.
	 *
	 * @param args   commandline options (first argument = test method name to run)
	 *
	 * @throws Exception
	 */
    public static void main( String[] args ) throws Exception {
		if (args.length == 1) {
			TestSuite testSuite = new TestSuite();
			testSuite.addTest(new ControllableFolderTest(args[0]));
			junit.textui.TestRunner.run(testSuite);
		}
		else {
			junit.textui.TestRunner.run( suite() );
		}
    }
    
    /**
	 * Common test setup.
	 *
	 * @throws Exception
	 */
    protected void setUp() throws Exception {
		super.setUp ();
    }
    
    /**
	 * Tears down the fixture, for example, close a network connection.
	 * This method is called after a test is executed.
	 *
	 * @throws Exception
	 */
    protected void tearDown() throws Exception {
    }
	
	/**
	 * Creates a folder structure to be used in the test (root folder is defined
	 * in the configuration file).
	 * <ul>
	 * <li>/foo/a.xml
	 * <li>/bar
	 * <li>/bar/b.xml
	 * <li>/bar/c.xml
	 * Updates the variable counting the resources created for the test.
	 *
	 * @throws   Exception
	 *
	 */
	private void createTestFolderStructure() throws Exception {
		
		String newLocationPath = folderPath + "/" + testFileName1;
		location = provider.location(newLocationPath);
		resource = location.controllableResource();
		resource.doCreateResource();
		resource.doControl();
		assertTrue( resourceExistsOnServer(newLocationPath) );
		numberOfCreatedResources+=1;
		
		newLocationPath = folderPath + "/" + testFolderBar;
		location = provider.location(newLocationPath);
		ControllableFolder subfolder = (ControllableFolder)location.folder();
		subfolder.doCreateResource();
		assertTrue( resourceExistsOnServer(newLocationPath) );
		numberOfCreatedResources+=1;
		
		newLocationPath = folderPath + "/" + testFolderBar + "/" + testFileName2;
		location = provider.location(newLocationPath);
		resource = location.controllableResource();
		resource.doCreateResource();
		resource.doControl();
		assertTrue( resourceExistsOnServer(newLocationPath) );
		numberOfCreatedResources+=1;
		
		newLocationPath = folderPath + "/" + testFolderBar + "/" + testFileName3;
		location = provider.location(newLocationPath);
		resource = location.controllableResource();
		resource.doCreateResource();
		resource.doControl();
		assertTrue( resourceExistsOnServer(newLocationPath) );
		numberOfCreatedResources+=1;
	}
    
	/**
	 * <ul>
	 * <li>Checks creation of a folder.
	 * <li>Folder should exist (of course) afterwards.
	 *
	 * @throws   Exception
	 *
	 */
    public void testDoCreateResource() throws Exception {
		location = provider.location( folderPath );
		folder = createControllableFolder(location);
		assertTrue( resourceExistsOnServer(folderPath) );
    }
    
	/**
	 * <ul>
	 * <li>Checks creating a folder twice.
	 * <li>WvcmException expected, with reason=RESOURCE_ALREADY_EXISTS_AT_LOCATION
	 *
	 * @throws   Exception
	 *
	 */
    public void testPreResourceMustBeNull() throws Exception {
		location = provider.location( folderPath );
		folder = createControllableFolder(location);
		assertTrue( resourceExistsOnServer(folderPath) );
		
		try {
			folder.doCreateResource();
			fail("Exception Expected. Folder already exists. Cannot be created again.");
		}
		catch (WvcmException e) {
			assertEquals( ReasonCode.RESOURCE_ALREADY_EXISTS_AT_LOCATION, e.getReasonCode() );
		}
    }
    
    /**
	 * <ul>
	 * <li>Checks creation of a ControllableFolder
	 * <li>
	 *
	 * @throws Exception
	 */
	public void testDoCreateResourceWrongPath() throws Exception {
		location = provider.location(rootFolderPath() + "Hello");
		folder = (ControllableFolder)location.folder();
		try {
			folder.doCreateResource();
			fail("Folder should not have been created.");
		}
		catch (WvcmException we) {
			// TODO: Ask Peter Nevermann about the right ReasonCode here.
			// The reason code in the exception should be, FORBIDDEN??
		}
	}
	
	/**
	 * <ul>
	 * <li>Create test folder (folder should have no members).
	 * <li>readMemberList(props, true).
	 * <li>Iterator returned should be empty.
	 *
	 * @throws Exception
	 */
	public void testReadMemberListNoMembers() throws Exception {
//		Iterator members;
//
//		location = provider.location( folderPath );
//		folder = createControllableFolder(location);
//		assertTrue( resourceExistsOnServer(folderPath) );
//
//
//		members = folder.readMemberList(null, true);
		fail("Functionality Not Implemented. IGNORE.");
	}
	
	/**
	 * <ul>
	 * <li>Create test folder (folder should contain some members).
	 * <li>Create PropertyNameList with properties to be found in client host.
	 * <li>readMemberList(props, true)
	 * <li>Iterator returned should contain the Resources with the wished props.
	 *
	 * @throws Exception
	 */
	public void testReadMemberListMembers() throws Exception {
		fail("Functionality Not Implemented. IGNORE.");
	}
	
	// TODO: WRITE MORE TEST CASES FOR readMemberList WHEN INFO IS THERE.
	
	/**
	 * <ul>
	 * <li>Create test folder (with no resources in it).
	 * <li>Folder created should have ECLIPSED_LIST as wanted property.
	 * <li>getEclipsedList
	 * <li>List returned should be empty.
	 *
	 * @throws Exception
	 */
	public void testGetEclipsedListEmptyFolder() throws Exception {
		
//		location = provider.location( folderPath );
//		folder = createControllableFolder(location);
//		assertTrue( resourceExistsOnServer(folderPath) );
//
//		PropertyNameList wantedProps = new PropertyNameList( new PropertyName[]
//															{PropertyName.ECLIPSED_LIST });
//
//		folder = (ControllableFolder)folder.doReadProperties( wantedProps );
//
//		List EclipsedList = folder.getEclipsedList() ;
//
//		assertFalse("Member List is not Empty.", EclipsedList.size()> 0);
		fail("Functionality not implemented. IGNORE.");
		
	}
	
	/**
	 * <ul>
	 * <li>Create test folder (with some resx in it; none of the resources
	 * are eclipsed by non-version-controlled resx).
	 * <li>Folder created should have ECLIPSED_LIST as wanted property
	 * <li>getEclipsedList
	 * <li>List returned contains the names of the eclipsed VC resx.
	 *
	 * @throws Exception
	 */
	public void testGetEclipsedListEmpty() throws Exception {
		fail("Not Implemented.");
	}
	
	/**
	 * <ul>
	 * <li>Create test folder.
	 * <li>Folder created should not have ECLIPSED_LIST as wanted property.
	 * <li>getEclipsedList
	 * <li>WvcmException should be thrown.
	 *
	 * @throws Exception
	 */
	public void testGetEclipsedListNotValid() throws Exception {
		
		fail("Functionality Not implemented. IGNORE.");
		
	}
	
	/**
	 * <ul>
	 * <li>Create test folder (with some resources in it).
	 * <li>Folder created should have ECLIPSED_LIST as wanted property
	 * <li>getEclipsedList
	 * <li>List returned contains the names of the eclipsed VC resx.
	 *
	 * @throws Exception
	 */
	public void testGetEclipsedList() throws Exception {
		fail("Not Implemented.");
	}
	
	/**
	 * <ul>
	 * <li>Create a controllable folder.
	 * <li>Read its property VERSION_CONTROLLABLE. This property shows whether
	 * version history will be tracked when the resource is controlled.
	 * <li>Should return false.
	 *
	 * @throws Exception
	 */
    public void testGetVersionControllableFolder() throws Exception {
		
		location = provider.location( folderPath );
		folder = createControllableFolder(location);
		PropertyNameList wantedprops =
			new PropertyNameList( new PropertyName[]{PropertyName.VERSION_CONTROLLABLE} );
		folder = (ControllableFolder)folder.doReadProperties( wantedprops );
		
		assertFalse("Unexpected result from folder version controllable.",
					folder.getVersionControllable() );
    }
}
