/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/wvcm/test/junit/src/org/apache/wvcm/test/GroupTest.java,v 1.3 2004/07/30 06:52:33 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:33 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */
package org.apache.wvcm.test;

import java.util.Iterator;
import javax.wvcm.Folder;
import javax.wvcm.Principal;
import javax.wvcm.Principal.Group;
import javax.wvcm.Principal.Role;
import javax.wvcm.PropertyNameList;
import javax.wvcm.PropertyNameList.NestedPropertyName;
import javax.wvcm.PropertyNameList.PropertyName;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.wvcm.test.common.AbstractTest;

/**
 * Test functionality given by javax.wvcm.Principal.Group
 *
 * @author <a href="mailto:javier.gallego@softwareag.com">Javier Gallego</a>
 * @version $Revision: 1.3 $
 */
public class GroupTest extends AbstractTest {
	
	private static final PropertyNameList PRINCIPAL_PROPS_NAMEONLY = new PropertyNameList(
        new PropertyName[]{
            PropertyName.DISPLAY_NAME
        }
    );
    
    private static final PropertyNameList PRINCIPAL_PROPS = new PropertyNameList(
        new PropertyName[]{
            PropertyName.DISPLAY_NAME,
                PropertyName.GROUP_MEMBERSHIP
        }
    );
	
	private static final PropertyNameList GROUP_PROPS = new PropertyNameList(
        new PropertyName[]{
            PropertyName.DISPLAY_NAME,
                PropertyName.GROUP_MEMBER_LIST,
                PropertyName.GROUP_MEMBERSHIP
        }
    );
	
	private static final PropertyNameList GROUP_MEMBERS_DEEP = new PropertyNameList(
        new PropertyName[]{
            PropertyName.DISPLAY_NAME,
                new NestedPropertyName(
                PropertyName.GROUP_MEMBER_LIST, PRINCIPAL_PROPS_NAMEONLY)
        }
    );
	
	private String testUserName1 = "testU1";
	private String testGroupName1 = "testG1";
	private String testRoleName1 = "testR1";
	
	private Principal testUser1;
	private Group testGroup1;
	private Role testRole1;
    
	/**
	 * Default constructor. Initializes paths to user/group/roles folders.
	 *
	 * @param    testName            Name of the test.
	 *
	 * @throws   Exception
	 *
	 */
    public GroupTest(String testName) throws Exception {
        super(testName);
    }
    
    /**
     * Creates a TestSuite corresponding to this class.
     *
     * @return   a Test
     */
    public static Test suite() {
        return new TestSuite(GroupTest.class);
    }
    
    /**
	 * Start test suite contained in this class using the text interface. If a
	 * parameter is passed, it will use it as a test name and run only that test
	 * case.
	 *
	 * @param args   commandline options (first argument = test method name to run)
	 *
	 * @throws Exception
	 */
    public static void main( String[] args ) throws Exception{
		if (args.length == 1) {
			TestSuite testSuite = new TestSuite();
			testSuite.addTest(new GroupTest(args[0]));
			junit.textui.TestRunner.run(testSuite);
		}
		else {
			junit.textui.TestRunner.run( suite() );
		}
    }
    
    /**
     * Common test setup.
	 *
	 * @throws Exception
     */
    protected void setUp() throws Exception {
        super.setUp ();
    }
    
    /**
     * Tears down the fixture, for example, close a network connection.
     * This method is called after a test is executed.
	 *
	 * @throws Exception
     */
    protected void tearDown() throws Exception {
    }
	
	/**
	 * <ul>
	 * <li>Create a Principal.Group.
	 * <li>Check if creation has been successful.
	 *
	 * @throws Exception
	 */
	public void testDoCreateResource() throws Exception {
		testGroup1 = createGroup(testGroupName1, true);
	}
	
	/**
	 * <ul>
	 * <li>Create a Principal.Group.
	 * <li>Check that the group is empty.
	 *
	 * @throws Exception
	 */
	public void testGetGroupMemberListEmpty() throws Exception {
		fail("Not Implemented.");
	}
	
	/**
	 * <ul>
	 * <li>Create a Principal.Group.
	 * <li>Delete the location of the group.
	 * <li>Try to get or set the group member list.
	 *
	 * @throws Exception
	 */
	public void testUseGroupDeleted() throws Exception {
		fail("Not Implemented.");
	}
	
	/**
	 * <ul>
	 * <li>Create a Principal.Group.
	 * <li>Create some users and add them to it.
	 * <li>Get the group member list.
	 * <li>Check list for correctness.
	 * <li>Create one group and add it to the first one.
	 * <li>Get the group member list again.
	* <li>Check list again.
	 *
	 * @throws Exception
	 */
	public void testSetGetGroupMemberListNotEmpty() throws Exception {
		fail("Not Implemented.");
	}
	
	/**
	 * <ul>
	 * <li>Create a Principal.Group.
	 * <li>Try to set the group as a member of itself.
	 * <li>Exception should be thrown.
	 *
	 * @throws Exception
	 */
	public void testSetGroupMemberListItself() throws Exception {
		fail("Not Implemented.");
	}
	
	/**
	 * <ul>
	 * <li>Create a Principal.Group and a Principal.Role.
	 * <li>Try to set the role as a member of the group.
	 * <li>Exception should be thrown.
	 *
	 * @throws Exception
	 */
	public void testSetRoleAsGroupMember() throws Exception {
		fail("Not Implemented.");
	}
	
	/**
	 * <ul>
	 * <li>Create a Principal.Group.
	 * <li>Create a user and add it to the group.
	 * <li>Create an empty list and set it as member list.
	 * <li>Get the member list and check it.
	 *
	 * @throws Exception
	 */
	// TODO: CHECK HOW THIS SHOULD WORK. MEMBERS BEFORE ARE DELETED OR ADDED...
	public void testSetEmptyMemberList() throws Exception {
		fail("Not Implemented.");
	}
	
	/**
	 * <ul>
	 * <li>Creates some testUsers + Group.
	 * <li>Put testUsers inside testGroup.
	 * <li>Check that the testGroup contains the testUsers.
	 *
	 * @throws   Exception
	 *
	 */
    public void testListGroupsWithDirectMembers() throws Exception {
		// TODO: CREATE TEST USERS AND GROUP. ADD USERS TO GROUP (NOT ALL).
        location = provider.location(groupsFolderPath);
        Folder gf = location.folder();
        Iterator groups = gf.doReadMemberList(GROUP_PROPS, false);
		System.out.println("Groups folder:\n" + gf.location().string());
        System.out.println("\nList of all groups with members:");
        if (!groups.hasNext()) {
            System.out.println("*** empty ***");
        }
        while (groups.hasNext()) {
            Principal.Group g = (Principal.Group)groups.next();
            System.out.println("- "+g.getDisplayName()+" ["+g.location().string()+"]");
            System.out.println("  Members:");
            Iterator m = g.getGroupMemberList().iterator();
            if (!m.hasNext()) {
                System.out.println("  *** empty ***");
            }
            while (m.hasNext()) {
                Principal p = (Principal)m.next();
                System.out.println("  + : "+p.getDisplayName()+" ["+p.location().string()+"]");
            }
        }
    }
	
	/**
	 * <ul>
	 * <li>Create test user and group.
	 * <li>Add user to group.
	 * <li>Check that user is in group.
	 * <li>Create again (overwriting) the group.
	 * <li>Check in user properties if it belongs to the group (should not, or?)
	 * <li>Check in the groups props that the user does not belong to the group
	 * anymore.
	 *
	 * @throws Exception
	 */
	public void testOverwriteGroup() throws Exception {
		fail("Not Implemented.");
	}
}

