/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/wvcm/test/junit/src/org/apache/wvcm/test/ProviderTest.java,v 1.3 2004/07/30 06:52:33 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:33 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */

package org.apache.wvcm.test;

import java.util.Iterator;
import java.util.List;
import javax.wvcm.ControllableResource;
import javax.wvcm.Folder;
import javax.wvcm.Location;
import javax.wvcm.Provider;
import javax.wvcm.ProviderFactory;
import javax.wvcm.WvcmException;
import javax.wvcm.WvcmException.ReasonCode;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.wvcm.test.common.AbstractTest;

/**
 * Functional tests for javax.wvcm.Provider
 *
 * @author <a href="mailto:peter.nevermann@softwareag.com">Peter Nevermann</a>
 * @version $Revision: 1.3 $
 */
public class ProviderTest extends AbstractTest {
	
	private String testResourceName = "test.xml";
	
    /**
	 * Default Constructor
	 *
	 * @param    testName            Name of the test to run.
	 *
	 * @throws   Exception
	 *
	 */
    public ProviderTest(String testName) throws Exception {
		super(testName);
		resourcePath = rootFolderPath() + "/" + testResourceName;
    }
    
    /**
	 * Method suite
	 *
	 * @return   a Test
	 */
    public static Test suite() {
		return new TestSuite(ProviderTest.class);
    }
    
    /**
	 * Start test suite contained in this class using the text interface. If a
	 * parameter is passed, it will use it as a test name and run only that test
	 * case.
	 *
	 * @param args   commandline options (first argument = test method name to run)
	 *
	 * @throws Exception
	 */
    public static void main( String[] args ) throws Exception{
		if (args.length == 1) {
			TestSuite testSuite = new TestSuite();
			testSuite.addTest(new ProviderTest(args[0]));
			junit.textui.TestRunner.run(testSuite);
		}
		else {
			junit.textui.TestRunner.run( suite() );
		}
    }
    
    /**
	 * Common test setup.
	 *
	 * @throws Exception
	 */
    protected void setUp() throws Exception {
		super.setUp ();
    }
    
    /**
	 * Tears down the fixture, for example, close a network connection.
	 * This method is called after a test is executed.
	 *
	 * @throws Exception
	 */
    protected void tearDown() throws Exception {
    }
    
	/**
	 * <ul>
	 * <li>Create a provider giving a Null Callback class.
	 * <li>Create a resource to check if connection to server works.
	 * <li>Check expected Exceptions.
	 *
	 * @throws   Exception
	 *
	 */
    public void testProviderWithNullCallbackAndNoParameters() throws Exception {
		Provider testProvider = ProviderFactory.createProvider(
			"org.apache.wvcm.ProviderImpl", null );
		Location l = testProvider.location( "http://"
										   + host + ":" + port
										   + resourcePath );
		ControllableResource r = l.controllableResource();
		try {
			r.doUnbind();
			r.doCreateResource();
			fail( "Expected WvcmException to have been thrown");
		}
		catch (WvcmException expected) {
			assertEquals( resourcePath, expected.getLocation() );
			assertEquals( ReasonCode.UNAUTHORIZED, expected.getReasonCode() );
		}
    }
    
	/**
	 * <ul>
	 * <li>Get the Workspace Folder list from the default test provider.
	 * <li>Check that the folder received correspond with the expected ones.
	 *
	 * @throws   Exception
	 *
	 */
    public void testServerWorkspaceFolderList() throws Exception {
		List wfl = provider.serverWorkspaceFolderList(null);
		
		assertNotNull("Not expected: Server workspace folder list is null.", wfl);
		assertTrue("Not expected: Server workspace folder list is empty.", wfl.size() > 0);
		
		// TODO: can a check be added about correctness of the returned list?
    }
	
	/**
	 * <ul>
	 * <li>Create a Location.
	 * <li>Check that the string value for the created location is correct.
	 *
	 * @throws Exception
	 */
	public void testLocation() throws Exception {
		fail("Not Implemented.");
	}
	
	/**
	 * <ul>
	 * <li>Try to get a location passing invalid chars in the String.
	 * <li>WvcmException should be thrown with ILLEGAL_LOCATION_SYNTAX.
	 *
	 * @throws Exception
	 */
	public void testInvalidLocation() throws Exception {
		fail("Not Implemented.");
	}
}

