/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/wvcm/test/junit/src/org/apache/wvcm/test/VersionTest.java,v 1.3 2004/07/30 06:52:33 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:33 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */

package org.apache.wvcm.test;
import java.util.List;

import javax.wvcm.ControllableResource;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Version;
import javax.wvcm.PropertyNameList.PropertyName;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.apache.wvcm.test.common.AbstractTest;

/**
 * Provide functional tests for javax.wvcm.Version
 *
 * @author <a href="mailto:peter.nevermann@softwareag.com">Peter Nevermann</a>
 * @version $Revision: 1.3 $
 */
public class VersionTest extends AbstractTest {

	/**
	 * Default Constructor
	 *
	 * @param    testName            Name of the test to run.
	 *
	 * @throws   Exception
	 *
	 */
	public VersionTest(String testName) throws Exception {
		super(testName);
		resourcePath = rootFolderPath() + "/test.xml";
		folderPath = rootFolderPath() + "/foo";
		resourceInFolderPath = folderPath + "/test.xml";
		missingFolderPath = rootFolderPath() + "/bar";
		resourceInMissingFolderPath = rootFolderPath() + "/bar/test.xml";
	}

	/**
	 * Method suite
	 *
	 * @return   a Test
	 */
	public static Test suite() {
		return new TestSuite(VersionTest.class);
	}

	/**
	 * Start test suite contained in this class using the text interface. If a
	 * parameter is passed, it will use it as a test name and run only that test
	 * case.
	 *
	 * @param args   commandline options (first argument = test method name to run)
	 *
	 * @throws Exception
	 */
    public static void main( String[] args ) throws Exception{
		if (args.length == 1) {
			TestSuite testSuite = new TestSuite();
			testSuite.addTest(new VersionTest(args[0]));
			junit.textui.TestRunner.run(testSuite);
		}
		else {
			junit.textui.TestRunner.run( suite() );
		}
    }

	/**
	 * Common test setup.
	 *
	 * @throws Exception
	 */
	protected void setUp() throws Exception {
		super.setUp();
		// TODO: ADD CREATION OF RESOURCE AND ITS VERSION HISTORY. IT COULD GO HERE OR SEPARATELY.
	}

	/**
	 * Tears down the fixture, for example, close a network connection.
	 * This method is called after a test is executed.
	 *
	 * @throws Exception
	 */
	protected void tearDown() throws Exception {
	}
	
	/**
	 * <ul>
	 * <li>Create a resource that identifies a version.
	 * <li>Try to write some content on it.
	 * <li>Exception should be thrown.
	 *
	 * @throws Exception
	 */
	public void testDoWrite() throws Exception {
		fail("Not Implemented.");
	}

	// TODO: ADD doUnbind TESTS. CHECK IN RESOURCE DOCUMENTATION.
	/**
	 * <ul>
	 * <li>Create a resource. Put it under control.
	 * <li>Create a Version of it (maybe before one or two checkin/checkouts have
	 * to be done).
	 * <li>Call {@link javax.wvcm.Resource#doUnbind() doUnbind} on that Version.
	 * <li>Exception could be thrown.
	 *
	 * @throws Exception
	 */
	public void testDoUnbindOnVersion() throws Exception {
		fail("Not Implemented.");
	}

	// TODO: IF ON testDoUnbindVersion IS NOT THROWN AN EXCEPTION, ANOTHER TESTCASE IS TO BE WRITTEN.

	/**
	 * <ul>
	 * <li>If a version has been unbound:
	 * <li>Check PredecessorList has been replaced by a copy of the unbound version.
	 *
	 * @throws Exception
	 */
	public void testVersionUnboundPredecessorList() throws Exception {
		fail("Not Implemented.");
	}

	/**
	 * <ul>
	 * <li>If a version has been unbound:
	 * <li>Refs to that version in a MergeList property must have been removed.
	 *
	 * @throws Exception
	 */
	public void testVesionUnboundMergeList() throws Exception {
		fail("Not Implemented.");
	}

	/**
	 * <ul>
	 * <li>Delete Version root.
	 * <li>RootVersion of the version history must be accordingly updated (check
	 * Resource javadoc for doUnbind()).
	 *
	 * @throws Exception
	 */
	public void testVersionRootUnbound() throws Exception {
		fail("Not Implemented.");
	}

	/**
	 * <ul>
	 * <li>Delete a version history.
	 * <li>All versions in the VersionList of that version history must have been
	 * unbound.
	 * <li>Postcondition for version deletion must also be checked. (Check {@link
	 * VersionTest#testVersionRootUnbound testVersionRootUnbound}).
	 *
	 * @throws Exception
	 */
	public void testVersionSetUnbind() throws Exception {
		fail("Not Implemented.");
	}

	/**
	 * <ul>
	 * <li>Create a test resource and put it under control.
	 * <li>Read property CHECKED_IN.
	 * <li>Check Version received.
	 * <li>Add, Remove and Set labels on the resource.
	 * <li>Check the label list of the version in each of the cases.
	 *
	 * @throws   Exception
	 *
	 */
	public void testDoXyzLabel() throws Exception {
		List labelList;
		String[] testLabels =
			new String[] { "labelAlpha", "labelBeta", "labelOmega" };
		location = provider.location(resourcePath);
		resource = createControllableResource(location);
		resource.doControl();

		PropertyNameList wantedprops;
		PropertyName[] rPNames = { PropertyName.CHECKED_IN };
		wantedprops = new PropertyNameList(rPNames);
		resource = (ControllableResource)resource.doReadProperties(wantedprops);
		Version version = resource.getCheckedIn();
		assertTrue(
			"VERSION NUMBER UNEXPECTED.",
			version.location().string().endsWith("1.0"));

		PropertyName[] vPNames = { PropertyName.LABEL_NAME_LIST };
		wantedprops = new PropertyNameList(vPNames);
		version = (Version)version.doReadProperties(wantedprops);
		labelList = version.getLabelNameList();
		assertEquals("Unexpected size of Label list.", 0, labelList.size());

		// Add label alpha
		resource.doAddLabel(testLabels[0]);
		version = (Version)version.doReadProperties(wantedprops);
		labelList = version.getLabelNameList();
		assertEquals("Unexpected size of Label list.", 1, labelList.size());
		for (int i = 0; i < labelList.size(); i++) {
			assertEquals(
				"Unexpected label received.",
				testLabels[i],
				labelList.get(i));
		}

		// Add label omega
		resource.doAddLabel(testLabels[1]);
		version = (Version)version.doReadProperties(wantedprops);
		labelList = version.getLabelNameList();
		assertEquals("Unexpected size of Label list.", 2, labelList.size());
		for (int i = 0; i < labelList.size(); i++) {
			assertEquals(
				"Unexpected label received.",
				testLabels[i],
				labelList.get(i));
		}

		// remove label alpha
		resource.doRemoveLabel(testLabels[0]);
		version = (Version)version.doReadProperties(wantedprops);
		labelList = version.getLabelNameList();
		assertEquals("Unexpected size of Label list.", 1, labelList.size());

		assertEquals(
			"Unexpected label received.",
			testLabels[1],
			labelList.get(0));

		// Set label rc1
		resource.doSetLabel(testLabels[2]);
		version = (Version)version.doReadProperties(wantedprops);
		labelList = version.getLabelNameList();
		assertEquals("Unexpected size of Label list.", 2, labelList.size());

		for (int i = 0; i < labelList.size(); i++) {
			assertEquals(
				"Unexpected label received.",
				testLabels[i + 1],
				labelList.get(i));
		}
	}

	/**
	 * <ul>
	 * <li>Obtain a resource that identifies a version.
	 * <li>Try to rebind that resource.
	 * <li>WvcmException should be thrown.
	 *
	 * @throws Exception
	 */
	public void testDoRebindVersion() throws Exception {
		fail("Not Implemented.");
	}

	/**
	 * <ul>
	 * <li>Get an instance of a version.
	 * <li>Get the Activity List.
	 * <li>Check that list contains correct elements.
	 *
	 * @throws Exception
	 */
	// TODO: GET MORE INFORMATION ABOUT HOW THIS METHOD WORK.
	// AND ADD MORE TEST CASES ABOUT IT.
	public void testGetActivityList() throws Exception {
		fail("Not implemented.");
	}
	
	/**
	 * <ul>
	 * <li>Get an instance of a version resource.
	 * <li>Get checkin fork.
	 * <li>Set checkin fork to a different value.
	 * <li>Persist changes. (this may not be necessary).
	 * <li>Get checkin fork again.
	 * <li>Check value received.
	 *
	 * @throws Exception
	 */
	public void testSetGetCheckinFork() throws Exception {
		fail("Not implemented.");
	}
	
	/**
	 * <ul>
	 * <li>Get an instance to a version resource.
	 * <li>Get the CheckoutFork property of the version.
	 * <li>Set the CheckoutFork property to a different value.
	 * <li>Persist change.
	 * <li>Get the CheckoutFork property once more.
	 * <li>Check the value received.
	 *
	 * @throws Exception
	 */
	public void testSetGetCheckoutFork() throws Exception {
		fail("Not implemented.");
	}
	
	// TODO: GET MORE INFO ABOUT HOW DO THE METHODS IN THIS CLASS WORK. IMPORTANT FOR EACH TEST CASE PREREQUISITES.
	
	/**
	 * <ul>
	 * <li>Get an instance of a version resource.
	 * <li>Get the checkout list.
	 * <li>Check that the returned list is correct.
	 *
	 * @throws Exception
	 */
	// TODO: ONCE IT IS CLEAR WHAT THIS METHOD RETURNS, ADD MORE TEST CASES ABOUT IT (HOW TO GET AN EMPTY LIST...)
	public void testGetCheckoutList() throws Exception {
		fail("Not implemented.");
	}
	
	/**
	 * <ul>
	 * <li>
	 * <li>
	 *
	 * @throws Exception
	 */
	// TODO: CHECK METHOD testDoXyzLabel FOR EXISTING TEST CASES. ADD SOME MORE IF NECESSARY.
	public void testGetLabelNameList() throws Exception {
		fail("Not implemented.");
	}
	
	/**
	 * <ul>
	 * <li>Get an instance of a version resource with no predecessors.
	 * <li>Get its predecessor list.
	 * <li>Check that the list is emtpy.
	 *
	 * @throws Exception
	 */
	public void testGetPredecessorListNoPredecessors() throws Exception {
		fail("Not implemented.");
	}
	
	/**
	 * <ul>
	 * <li>Get an instance of a version resource with some predecessors.
	 * <li>Get its predecessor list.
	 * <li>Check that the list is correct.
	 *
	 * @throws Exception
	 */
	public void testGetPredecessorListNotEmpty() throws Exception {
		fail("Not implemented.");
	}
	
	/**
	 * <ul>
	 * <li>Get an instance of a version resource without successors.
	 * <li>Get the successor list of the resource.
	 * <li>List should be empty.
	 *
	 * @throws Exception
	 */
	public void testGetSuccessorListNoSuccessors() throws Exception {
		fail("Not implemented.");
	}
	
	/**
	 * <ul>
	 * <li>Get an instance of a version resource with successors.
	 * <li>Get its successors list.
	 * <li>Check that list is correct.
	 *
	 * @throws Exception
	 */
	public void testGetSuccessorListNotEmpty() throws Exception {
		fail("Not implemented.");
	}
	
	/**
	 * <ul>
	 * <li>Get an instance of a version resource.
	 * <li>Get its version history.
	 * <li>Check that the instance returned corresponds to the version history that
	 * contains this version.
	 *
	 * @throws Exception
	 */
	public void testGetVersionHistoryValid() throws Exception {
		fail("Not implemented.");
	}
	
	/**
	 * <ul>
	 * <li>Create a resource.
	 * <li>Put it under version control. Check it out and in twice.
	 * <li>Get its version history and from it a version.
	 * <li>Delete the resource.
	 * <li>Get the version history from the version instance got before.
	 * <li>Exception should be thrown.
	 *
	 * @throws Exception
	 */
	// TODO: CHECK IF AFTER DELETING A RESOURCE ITS VERSION HISTORY IS ALSO DELETED...
	public void testGetVersionHistoryDeletedResource() throws Exception {
		fail("Not Implemented.");
	}
	
	/**
	 * <ul>
	 * <li>Get an instance of a version resource.
	 * <li>Get its version name.
	 * <li>Check that the version name returned is correct.
	 *
	 * @throws Exception
	 */
	public void testGetVersionName() throws Exception {
		fail("Not implemented.");
	}
	
	/**
	 * <ul>
	 * <li>Get a Version from a resource.
	 * <li>Try to copy it to some existing location.
	 * <li>An exception should be thrown.
	 *
	 * @throws Exception
	 */
	// TODO: CHECK IF EXPECTED RESULT IS CORRECT.
	public void testDoCopyVersion() throws Exception {
		fail("Not Implemented.");
	}
	
	/**
	 * <ul>
	 * <li>Get a Version of a controlled resource.
	 * <li>Get some properties from it.
	 * <li>Properties values are as expected.
	 * <li>Try to set a property to it.
	 * <li>An exception should be thrown.
	 *
	 * @throws Exception
	 */
	// TODO: CHECK WHAT PROPERTIES SHOULD BE USED IN THIS TEST CASE.
	public void testSetGetProperty() throws Exception {
		fail("Not Implemented.");
	}
	
}
