/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/wvcm/test/junit/src/org/apache/wvcm/test/WorkspaceTest.java,v 1.3 2004/07/30 06:52:33 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:33 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */

package org.apache.wvcm.test;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.wvcm.ControllableResource;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Version;
import javax.wvcm.WvcmException;
import javax.wvcm.PropertyNameList.PropertyName;
import javax.wvcm.WvcmException.ReasonCode;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.apache.wvcm.test.common.AbstractTest;

/**
 * Provides functional tests for javax.wvcm.Workspace.
 *
 * @author <a href="mailto:peter.nevermann@softwareag.com">Peter Nevermann</a>
 * @version $Revision: 1.3 $
 */
public class WorkspaceTest extends AbstractTest {
    
    private String invalidWorkspacePath = null;
    
	/**
	 * Default Constructor
	 *
	 * @param    testName            Name of the test to be run.
	 *
	 * @throws   Exception
	 *
	 */
    public WorkspaceTest(String testName) throws Exception {
		super(testName);
		resourcePath = rootFolderPath()+"/test.xml";
		this.invalidWorkspacePath = contextPath()+"/invalidWsPath";
    }
    
    /**
	 * Method suite
	 *
	 * @return   a Test
	 */
    public static Test suite() {
		return new TestSuite(WorkspaceTest.class);
    }
    
    /**
	 * Start test suite contained in this class using the text interface. If a
	 * parameter is passed, it will use it as a test name and run only that test
	 * case.
	 *
	 * @param args   commandline options (first argument = test method name to run)
	 *
	 * @throws Exception
	 */
    public static void main( String[] args ) throws Exception{
		if (args.length == 1) {
			TestSuite testSuite = new TestSuite();
			testSuite.addTest(new WorkspaceTest(args[0]));
			junit.textui.TestRunner.run(testSuite);
		}
		else {
			junit.textui.TestRunner.run( suite() );
		}
    }
    
    /**
	 * Tests common setup.
	 *
	 * @throws Exception
	 */
    protected void setUp() throws Exception {
		super.setUp ();
    }
    
    /**
	 * Tears down the fixture, for example, close a network connection.
	 * This method is called after a test is executed.
	 *
	 * @throws Exception
	 */
    protected void tearDown() throws Exception {
    }
	
	/**
	 * Get the Workspace Folder List of the given provider and check that the
	 * list is neither null nor empty.
	 *
	 * @return   A list with the workspace folders.
	 *
	 * @throws   WvcmException
	 */
	private List getWorkspaceFolderList() throws WvcmException {
		List wfl = provider.serverWorkspaceFolderList( null );
		assertNotNull("Workspace Folders List is null unexpectedly.", wfl );
		assertFalse("Workspace Folder List size is 0 unexpectedly.",
					wfl.size() == 0 );
		return wfl;
	}
    
    /**
	 * <ul>
	 * <li>Get the workspace folder list for the test server.
	 * <li>Try to create a folder in one of the folders received.
	 * <li>Check workspace folder is created.
	 *
	 * @throws Exception
	 */
	public void testDoCreateResource() throws Exception {
		List wfl = getWorkspaceFolderList();
		workspacePath = wfl.get(0)+"/ws1";
		
		location = provider.location( workspacePath );
		workspace = createWorkspace(location);
		assertTrue("Workspace folder failed to create.",
				   resourceExistsOnServer(workspacePath) );
    }
    
    /**
	 * <ul>
	 * <li>Get the list of workspaces in the server.
	 * <li>Create a workspace folder.
	 * <li>Check that it has been created and try to create it again.
	 * <li>Check that an Exception is thrown with the correct ReasonCode.
	 *
	 * @throws Exception
	 */
	// TODO: ADD DOCUMENTATION
	public void testPreResourceMustBeNull() throws Exception {
		List wfl = getWorkspaceFolderList();
		workspacePath = wfl.get(0)+"/ws1";
		
		location = provider.location( workspacePath );
		workspace = createWorkspace(location);
		assertTrue( resourceExistsOnServer(workspacePath) );
		try {
			workspace.doCreateResource();
			fail("Exception is expected after creating workspace twice.");
		}
		catch (WvcmException expected) {
			assertEquals( ReasonCode.RESOURCE_ALREADY_EXISTS_AT_LOCATION,
						 expected.getReasonCode() );
		}
    }
	
	/**
	 * <ul>
	 * <li>Get a workspace instance at an invalid path.
	 * <li>Try to create that workspace.
	 * <li>An Exception should be thrown.
	 *
	 * @throws Exception
	 */
	public void testPreWorkspaceLocationAllowed() throws Exception {
		location = provider.location( invalidWorkspacePath );
		workspace = location.workspace();
		try {
			workspace.doUnbind();
			workspace.doCreateResource();
			fail("Exception expected");
		}
		catch (WvcmException expected) {
			assertEquals(ReasonCode.CANNOT_CREATE_AT_THIS_LOCATION,
						 expected.getReasonCode() );
		}
    }
    
    /**
	 * <ul>
	 * <li>
	 * <li>
	 *
	 * @throws Exception
	 */
	// TODO: ADD DOCUMENTATION
	public void testLocateByHistoryReport() throws Exception {
		// Create the workspace
		List wfl = getWorkspaceFolderList();
		workspacePath = wfl.get(0)+"/ws1";
		
		location = provider.location( workspacePath );
		workspace = createWorkspace(location);
		String wspath = workspace.location().string();
		
		// create the files
		List vhlist = new ArrayList();
		ControllableResource resource;
		Version v;
		PropertyNameList pnlist = new PropertyNameList(
			new PropertyName[]{
				PropertyName.DISPLAY_NAME,
				PropertyName.VERSION_HISTORY,
				PropertyName.CHECKED_IN}
		);
		// ... in history list only
		location = provider.location( resourcePath+".1" );
		resource = location.controllableResource();
		resource.doUnbind();
		resource.doCreateResource();
		resource.doControl();
		resource = (ControllableResource)resource.doReadProperties( pnlist );
		vhlist.add( resource.getVersionHistory() );
		// ... in history list and in workspace
		location = provider.location( resourcePath+".2" );
		resource = location.controllableResource();
		resource.doUnbind();
		resource.doCreateResource();
		resource.doControl();
		resource = (ControllableResource)resource.doReadProperties( pnlist );
		vhlist.add( resource.getVersionHistory() );
		v = resource.getCheckedIn();
		location = provider.location( wspath+"/test.2.xml" );
		resource = location.controllableResource();
		resource.doCreateVersionControlledResource( v );
		// ... in history list and in workspace
		location = provider.location( resourcePath+".3" );
		resource = location.controllableResource();
		resource.doUnbind();
		resource.doCreateResource();
		resource.doControl();
		resource = (ControllableResource)resource.doReadProperties( pnlist );
		vhlist.add( resource.getVersionHistory() );
		v = resource.getCheckedIn();
		location = provider.location( wspath+"/test.3.xml" );
		resource = location.controllableResource();
		resource.doCreateVersionControlledResource( v );
		// ... in workspace only
		location = provider.location( resourcePath+".4" );
		resource = location.controllableResource();
		resource.doUnbind();
		resource.doCreateResource();
		resource.doControl();
		resource = (ControllableResource)resource.doReadProperties( pnlist );
		v = resource.getCheckedIn();
		location = provider.location( wspath+"/test.4.xml" );
		resource = location.controllableResource();
		resource.doCreateVersionControlledResource( v );
		
		System.out.println( "Expecting: test.2.xml and test.3.xml: " );
		Iterator i = workspace.doLocateByHistoryReport(vhlist, pnlist).iterator();
		while( i.hasNext() ) {
			ControllableResource r = (ControllableResource)i.next();
			System.out.println("- "+r.location().string());
			System.out.println("  display-name: "+r.getDisplayName());
			System.out.println("  version-history: "+r.getVersionHistory().location().string());
		}
    }
	
	/**
	 * <ul>
	 * <li>Create a resource (check workspace property).
	 * <li>Obtain a resource identifying the workspace of the created resource.
	 * <li>Make a rebind on the workspace.
	 * <li>Check that the references to that workspace have been updated.
	 *
	 * @throws Exception
	 */
	public void testDoRebindWorkspaceCheckProperty() throws Exception {
		fail("Not Implemented.");
	}
	
	/**
	 * <ul>
	 * <li>Obtain a resource identifying a workspace.
	 * <li>Make a rebind on the workspace.
	 * <li>Check that references to that workspace in a CurrentWorkspaceList
	 * have been updated.
	 *
	 * @throws Exception
	 */
	public void testDoRebindWorkspaceCheckReference() throws Exception {
		fail("Not Implemented.");
	}
	
	/**
	 * <ul>
	 * <li>Create a resource and put it under control (check workspace property).
	 * <li>Obtain a resource identifying the workspace of the created resource.
	 * <li>Make a rebind on the workspace.
	 * <li>Check that the references to that workspace have been updated.
	 *
	 * @throws Exception
	 */
	public void testDoRebindWorkspaceControlledResx() throws Exception {
		fail("Not Implemented.");
	}
	
	/**
	 * <ul>
	 * <li>Get a valid Workspace instance.
	 * <li>Make a getWorkspace on that instance.
	 * <li>The returned Workspace should identify itself.
	 *
	 * @throws Exception
	 */
	public void testGetWorkspace() throws Exception {
		fail("Not Implemented.");
	}
}

