/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/wvcm/test/junit/src/org/apache/wvcm/test/common/util/PropertiesHelper.java,v 1.3 2004/07/30 06:52:35 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:35 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */


package org.apache.wvcm.test.common.util;

import javax.wvcm.ControllableResource;
import javax.wvcm.PropertyNameList;
import javax.wvcm.PropertyNameList.PropertyName;
import javax.wvcm.Resource;
import javax.wvcm.Version;
import javax.wvcm.WvcmException;

/**
 * This class provides some convenience methods to handle reading resource
 * properties easier.
 *
 * @author <a href="mailto:javier.gallego@softwareag.com">Javier Gallego</a>
 * @version $Revision: 1.3 $
 */
public class PropertiesHelper {
	
	/**
	 * This method reads the property CONTENT_IDENTIFIER from the passed resource.
	 *
	 * @param    aResource           Resource which content identifier is needed.
	 *
	 * @return   The content identifier of the resource.
	 *
	 * @throws   WvcmException	In case of problems while reading the resource's
	 * properties.
	 *
	 */
	public String getContentIdentifier(Resource aResource) throws WvcmException {
		PropertyNameList wantedprops =
			new PropertyNameList( new PropertyName[]{PropertyName.CONTENT_IDENTIFIER} );
		aResource = aResource.doReadProperties( wantedprops );
		String cid = aResource.getContentIdentifier();
		return cid;
	}
	
	/**
	 * Reads the property CONTENT_LENGTH and returns it.
	 *
	 * @param    aResource           Resource to read property from
	 *
	 * @return   Content length property of the passed resource.
	 *
	 * @throws   WvcmException In case of problems while reading props.
	 *
	 */
	public long getContentLength(Resource aResource) throws WvcmException {
		PropertyNameList wantedprops =
			new PropertyNameList( new PropertyName[]{PropertyName.CONTENT_LENGTH} );
		aResource = aResource.doReadProperties( wantedprops );
		long contentLength = aResource.getContentLength();
		return contentLength;
	}
	
	/**
	 * This method reads the following properties from the passed resource:
	 * <ul>
	 * <li>IS_CHECKED_OUT
	 * <li>CHECKED_IN
	 * <li>CHECKED_OUT
	 *
	 * @param    aResource           Resource whose properties are read.
	 *
	 * @return   ControllableResource with the read properties
	 *
	 * @throws   WvcmException
	 *
	 */
	public ControllableResource getResourceWithCheckProperties(Resource aResource) throws WvcmException {
		PropertyNameList wantedprops = new PropertyNameList(
			new PropertyName[] {
				PropertyName.IS_CHECKED_OUT,
					PropertyName.CHECKED_IN,
					PropertyName.CHECKED_OUT
			}
		);
		return (ControllableResource)aResource.doReadProperties( wantedprops );
	}
	
	/**
	 * This method reads the property CHECKED_IN from the passed resource and
	 * returns the version checked in.
	 *
	 * @param    aResource           Resource whose version is returned.
	 *
	 * @return   Checked in version of the resource.
	 *
	 * @throws   WvcmException
	 *
	 */
	public Version getCheckedInPropertyAndVersion(ControllableResource aResource) throws WvcmException {
		PropertyNameList wantedprops = new PropertyNameList(
			new PropertyName[] {
				PropertyName.CHECKED_IN
			}
		);
		aResource = (ControllableResource)aResource.doReadProperties( wantedprops );
		return aResource.getCheckedIn();
	}
	
}

