/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/wvcm/test/junit/src/org/apache/wvcm/test/common/util/ReasonCodeChecker.java,v 1.3 2004/07/30 06:52:35 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:35 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2003 The Apache Software Foundation. All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1.Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2.Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3.The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4.The names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission.For written
 *    permission, please contact apache@apache.org.
 *
 * 5.Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES) LOSS OF
 * USE, DATA, OR PROFITS) OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation. For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */

package org.apache.wvcm.test.common.util;

import javax.wvcm.WvcmException.ReasonCode;
import javax.wvcm.WvcmException;

/**
 * This class performs checks on ReasonCode coming with a WvcmException.
 *
 * @author <a href="mailto:javier.gallego@softwareag.com">Javier Gallego</a>
 * @version $Revision: 1.3 $
 */
public class ReasonCodeChecker {
	
	
	/**
	 * Returns an String with the type of ReasonCode found in the passed
	 * exception.
	 *
	 * @param    exc                 Exception to get the ReasonCode from.
	 *
	 * @return   String representation of the ReasonCode found, or UNKNOWN if not
	 * found.
	 *
	 */
	public static String getReasonCodeAsString(WvcmException exc) {
		String reason = "UNKNOWN REASON CODE";
		if (exc.getReasonCode() == ReasonCode.READ_FAILED)
			reason = "READ_FAILED";
		else if (exc.getReasonCode() == ReasonCode.WRITE_FAILED)
			reason = "WRITE_FAILED";
		else if (exc.getReasonCode() == ReasonCode.VALUE_UNAVAILABLE)
			reason = "VALUE_UNAVAILABLE";
		else if (exc.getReasonCode() == ReasonCode.VALUE_UNAVAILABLE_LOCALLY)
			reason = "VALUE_UNAVAILABLE_LOCALLY";
		else if (exc.getReasonCode() == ReasonCode.PROPERTY_MISSING)
			reason = "PROPERTY_MISSING";
		else if (exc.getReasonCode() == ReasonCode.NO_CONTENT)
			reason = "NO_CONTENT";
		else if (exc.getReasonCode() == ReasonCode.NO_LOCAL_CONTENT)
			reason = "NO_LOCAL_CONTENT";
		else if (exc.getReasonCode() == ReasonCode.PROPERTY_OVERWRITE_FORBIDDEN)
			reason = "PROPERTY_OVERWRITE_FORBIDDEN";
		else if (exc.getReasonCode() == ReasonCode.UNAUTHORIZED)
			reason = "UNAUTHORIZED";
		else if (exc.getReasonCode() == ReasonCode.FORBIDDEN)
			reason = "FORBIDDEN";
		else if (exc.getReasonCode() == ReasonCode.NOT_FOUND)
			reason = "NOT_FOUND";
		else if (exc.getReasonCode() == ReasonCode.CONFLICT)
			reason = "CONFLICT";
		else if (exc.getReasonCode() == ReasonCode.WORKSPACE_SERVER_LOCATION_UNDEFINED)
			reason = "WORKSPACE_SERVER_LOCATION_UNDEFINED";
		else if (exc.getReasonCode() == ReasonCode.NOT_AN_ACTIVITY)
			reason = "NOT_AN_ACTIVITY";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_DELETE_VERSION_LIST)
			reason = "CANNOT_DELETE_VERSION_LIST";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_INITIALIZE_BINDINGS)
			reason = "CANNOT_INITIALIZE_BINDINGS";
		else if (exc.getReasonCode() == ReasonCode.CONTROLLED_CONFIGURATION_ALREADY_EXISTS)
			reason = "CONTROLLED_CONFIGURATION_ALREADY_EXISTS";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_CREATE_CONTROLLED_CONFIGURATION)
			reason = "CANNOT_CREATE_CONTROLLED_CONFIGURATION";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_REFERENCE_CONTROLLED_CONFIGURATION)
			reason = "CANNOT_REFERENCE_CONTROLLED_CONFIGURATION";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_ADD_TO_HISTORY)
			reason = "CANNOT_ADD_TO_HISTORY";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_DELETE_WORKSPACE_MEMBERS)
			reason = "CANNOT_DELETE_WORKSPACE_MEMBERS";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_RENAME_VERSION)
			reason = "CANNOT_RENAME_VERSION";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_REPORT_PROPERTIES)
			reason = "CANNOT_REPORT_PROPERTIES";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_INITIALIZE_ACTIVITY_LIST)
			reason = "CANNOT_INITIALIZE_ACTIVITY_LIST";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_FORK)
			reason = "CANNOT_FORK";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_SET_CONTROLLED_CONFIGURATION)
			reason = "CANNOT_SET_CONTROLLED_CONFIGURATION";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_RESTORE_CONTENT_AND_DEAD_PROPERTIES)
			reason = "CANNOT_RESTORE_CONTENT_AND_DEAD_PROPERTIES";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_UPDATE_BASELINE_FOLDER)
			reason = "CANNOT_UPDATE_BASELINE_FOLDER";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_HAVE_MULTIPLE_BASELINE_CONTROLLED_FOLDERS)
			reason = "CANNOT_HAVE_MULTIPLE_BASELINE_CONTROLLED_FOLDERS";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_CREATE_AT_THIS_LOCATION)
			reason = "CANNOT_CREATE_AT_THIS_LOCATION";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_UPDATE_MERGE_LIST)
			reason = "CANNOT_UPDATE_MERGE_LIST";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_MODIFY_CONTROLLED_PROPERTY)
			reason = "CANNOT_MODIFY_CONTROLLED_PROPERTY";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_OVERWRITE_BY_AUTO_UPDATE)
			reason = "CANNOT_OVERWRITE_BY_AUTO_UPDATE";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_MERGE_CHECKOUT_NOT_ALLOWED)
			reason = "CANNOT_MERGE_CHECKOUT_NOT_ALLOWED";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_CREATE_WORKING_RESOURCE)
			reason = "CANNOT_CREATE_WORKING_RESOURCE";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_CONTROL_FOLDER_MEMBERS)
			reason = "CANNOT_CONTROL_FOLDER_MEMBERS";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_MODIFY_CONTROLLED_CONTENT)
			reason = "CANNOT_MODIFY_CONTROLLED_CONTENT";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_RENAME_HISTORY)
			reason = "CANNOT_RENAME_HISTORY";
		else if (exc.getReasonCode() == ReasonCode.VERSIONING_PROPERTY_COPIED)
			reason = "VERSIONING_PROPERTY_COPIED";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_CHECKIN_ACTIVITY_RESOURCES)
			reason = "CANNOT_CHECKIN_ACTIVITY_RESOURCES";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_UPDATE_CHECKED_OUT_REFERENCE)
			reason = "CANNOT_UPDATE_CHECKED_OUT_REFERENCE";
		else if (exc.getReasonCode() == ReasonCode.NOT_A_BASELINE)
			reason = "NOT_A_BASELINE";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_CHECKOUT_FORKING_IS_FORBIDDEN)
			reason = "CANNOT_CHECKOUT_FORKING_IS_FORBIDDEN";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_CHECKOUT_MULTI_CHECKOUT_IS_DISCOURAGED)
			reason = "CANNOT_CHECKOUT_MULTI_CHECKOUT_IS_DISCOURAGED";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_MOVE_INTO_WORKSPACE)
			reason = "CANNOT_MOVE_INTO_WORKSPACE";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_UPDATE_VERSION_HISTORY_ROOT)
			reason = "CANNOT_UPDATE_VERSION_HISTORY_ROOT";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_RETRIEVE_SUPPORTED_PROPERTY)
			reason = "CANNOT_RETRIEVE_SUPPORTED_PROPERTY";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_CHECKOUT_MULTI_CHECKOUT_IS_FORBIDDEN)
			reason = "CANNOT_CHECKOUT_MULTI_CHECKOUT_IS_FORBIDDEN";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_INITIALIZE_PREDECESSOR_LIST)
			reason = "CANNOT_INITIALIZE_PREDECESSOR_LIST";
		else if (exc.getReasonCode() == ReasonCode.AUTO_CHECKIN_FAILED)
			reason = "AUTO_CHECKIN_FAILED";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_REMOVE_LABEL_DOES_NOT_EXIST)
			reason = "CANNOT_REMOVE_LABEL_DOES_NOT_EXIST";
		else if (exc.getReasonCode() == ReasonCode.BAD_VERSION_HISTORY)
			reason = "BAD_VERSION_HISTORY";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_UPDATE_WORKSPACE_REFERENCE)
			reason = "CANNOT_UPDATE_WORKSPACE_REFERENCE";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_CHECKIN_FORK_DISCOURAGED)
			reason = "CANNOT_CHECKIN_FORK_DISCOURAGED";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_UPDATE_CONTROLLED_FOLDER_MEMBERS)
			reason = "CANNOT_UPDATE_CONTROLLED_FOLDER_MEMBERS";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_CREATE_BASELINE_FOLDER)
			reason = "CANNOT_CREATE_BASELINE_FOLDER";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_PRESERVE_VERSIONING_PROPERTIES)
			reason = "CANNOT_PRESERVE_VERSIONING_PROPERTIES";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_MERGE_BASELINE)
			reason = "CANNOT_MERGE_BASELINE";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_PUT_UNDER_CONTROL)
			reason = "CANNOT_PUT_UNDER_CONTROL";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_DELETE_VERSION)
			reason = "CANNOT_DELETE_VERSION";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_ADD_OR_SET_LABEL)
			reason = "CANNOT_ADD_OR_SET_LABEL";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_UNCHECKOUT_NOT_CHECKED_OUT_RESOURCE)
			reason = "CANNOT_UNCHECKOUT_NOT_CHECKED_OUT_RESOURCE";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_SET_BASELINE_CONTROLLED_FOLDER_MEMBERS)
			reason = "CANNOT_SET_BASELINE_CONTROLLED_FOLDER_MEMBERS";
		else if (exc.getReasonCode() == ReasonCode.BAD_VERSION)
			reason = "BAD_VERSION";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_MODIFY_VERSION)
			reason = "CANNOT_MODIFY_VERSION";
		else if (exc.getReasonCode() == ReasonCode.BASELINES_FROM_SAME_HISTORY)
			reason = "BASELINES_FROM_SAME_HISTORY";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_CHECKIN_ALL_RESOURCES)
			reason = "CANNOT_CHECKIN_ALL_RESOURCES";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_RENAME_WORKING_RESOURCE)
			reason = "CANNOT_RENAME_WORKING_RESOURCE";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_CREATE_NEW_CONTROLLED_RESOURCE)
			reason = "CANNOT_CREATE_NEW_CONTROLLED_RESOURCE";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_SELECT_EXISTING_BASELINE)
			reason = "CANNOT_SELECT_EXISTING_BASELINE";
		else if (exc.getReasonCode() == ReasonCode.RESOURCE_ALREADY_EXISTS_AT_LOCATION)
			reason = "RESOURCE_ALREADY_EXISTS_AT_LOCATION";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_MODIFY_PROPERTIES)
			reason = "CANNOT_MODIFY_PROPERTIES";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_AUTO_CHECKOUT)
			reason = "CANNOT_AUTO_CHECKOUT";
		else if (exc.getReasonCode() == ReasonCode.CHECKOUT_OF_VERSION_WITH_DESCENDANT_IS_DISCOURAGED)
			reason = "CHECKOUT_OF_VERSION_WITH_DESCENDANT_IS_DISCOURAGED";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_UPDATE_ACTIVITY_REFERENCE)
			reason = "CANNOT_UPDATE_ACTIVITY_REFERENCE";
		else if (exc.getReasonCode() == ReasonCode.VERSION_HISTORY_IS_NOT_TREE)
			reason = "VERSION_HISTORY_IS_NOT_TREE";
		else if (exc.getReasonCode() == ReasonCode.MUST_SELECT_VERSION_IN_HISTORY)
			reason = "MUST_SELECT_VERSION_IN_HISTORY";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_COPY_FOLDER_VERSION)
			reason = "CANNOT_COPY_FOLDER_VERSION";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_UPDATE_CONTENT_AND_PROPERTIES)
			reason = "CANNOT_UPDATE_CONTENT_AND_PROPERTIES";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_HAVE_CONTROLLED_MEMBERS)
			reason = "CANNOT_HAVE_CONTROLLED_MEMBERS";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_CHANGE_EXISTING_CHECKED_IN_OUT)
			reason = "CANNOT_CHANGE_EXISTING_CHECKED_IN_OUT";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_UPDATE_DESCENDANT_VERSION)
			reason = "CANNOT_UPDATE_DESCENDANT_VERSION";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_UPDATE_AUTO_UPDATE)
			reason = "CANNOT_UPDATE_AUTO_UPDATE";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_COPY_HISTORY)
			reason = "CANNOT_COPY_HISTORY";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_CHECK_OUT)
			reason = "CANNOT_CHECK_OUT";
		else if (exc.getReasonCode() == ReasonCode.ONE_CONTROLLED_RESOURCE_PER_HISTORY_PER_WORKSPACE)
			reason = "ONE_CONTROLLED_RESOURCE_PER_HISTORY_PER_WORKSPACE";
		else if (exc.getReasonCode() == ReasonCode.INITIALIZE_CONTROLLED_BINDINGS)
			reason = "INITIALIZE_CONTROLLED_BINDINGS";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_MODIFY_CONFIGURATION)
			reason = "CANNOT_MODIFY_CONFIGURATION";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_UPDATE_MEMBERS_ARE_CHECKED_OUT)
			reason = "CANNOT_UPDATE_MEMBERS_ARE_CHECKED_OUT";
		else if (exc.getReasonCode() == ReasonCode.APPLY_REQUEST_TO_LABELED_VERSION)
			reason = "APPLY_REQUEST_TO_LABELED_VERSION";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_DELETE_VERSION_REFERENCE)
			reason = "CANNOT_DELETE_VERSION_REFERENCE";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_MERGE_SUB_BASELINES)
			reason = "CANNOT_MERGE_SUB_BASELINES";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_MERGE_CHECKED_OUT_RESOURCE)
			reason = "CANNOT_MERGE_CHECKED_OUT_RESOURCE";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_CANCEL_CHECKED_OUT)
			reason = "CANNOT_CANCEL_CHECKED_OUT";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_UPDATE_PREDECESSOR_LIST)
			reason = "CANNOT_UPDATE_PREDECESSOR_LIST";
		else if (exc.getReasonCode() == ReasonCode.ONE_CHECKOUT_PER_ACTIVITY_PER_HISTORY)
			reason = "ONE_CHECKOUT_PER_ACTIVITY_PER_HISTORY";
		else if (exc.getReasonCode() == ReasonCode.MUST_BE_CHECKED_IN)
			reason = "MUST_BE_CHECKED_IN";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_DEPTH_UPDATE)
			reason = "CANNOT_DEPTH_UPDATE";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_CHECK_IN)
			reason = "CANNOT_CHECK_IN";
		else if (exc.getReasonCode() == ReasonCode.MUST_BE_CHECKED_OUT)
			reason = "MUST_BE_CHECKED_OUT";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_UNBIND_ACTIVITY_REFERENCE)
			reason = "CANNOT_UNBIND_ACTIVITY_REFERENCE";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_CHECKIN_MERGE_NOT_COMPLETE)
			reason = "CANNOT_CHECKIN_MERGE_NOT_COMPLETE";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_CREATE_BRANCH_IN_ACTIVITY)
			reason = "CANNOT_CREATE_BRANCH_IN_ACTIVITY";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_MODIFY_CONTROLLED_CONFIGURATION)
			reason = "CANNOT_MODIFY_CONTROLLED_CONFIGURATION";
		else if (exc.getReasonCode() == ReasonCode.ONE_VERSION_PER_HISTORY_PER_BASELINE)
			reason = "ONE_VERSION_PER_HISTORY_PER_BASELINE";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_CREATE_NEW_VERSION_HISTORY)
			reason = "CANNOT_CREATE_NEW_VERSION_HISTORY";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_CREATE_NEW_RESOURCE)
			reason = "CANNOT_CREATE_NEW_RESOURCE";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_MERGE_ANCESTOR_VERSION)
			reason = "CANNOT_MERGE_ANCESTOR_VERSION";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_AUTO_UPDATE)
			reason = "CANNOT_AUTO_UPDATE";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_CHECKOUT_FOR_MERGE)
			reason = "CANNOT_CHECKOUT_FOR_MERGE";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_KEEP_CHECKED_OUT)
			reason = "CANNOT_KEEP_CHECKED_OUT";
		else if (exc.getReasonCode() == ReasonCode.ADD_MUST_BE_NEW_LABEL)
			reason = "ADD_MUST_BE_NEW_LABEL";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_MODIFY_CHECKED_IN_PARENT)
			reason = "CANNOT_MODIFY_CHECKED_IN_PARENT";
		else if (exc.getReasonCode() == ReasonCode.NO_CHECKED_OUT_BASELINE_CONTROLLED_FOLDER_MEMBERS)
			reason = "NO_CHECKED_OUT_BASELINE_CONTROLLED_FOLDER_MEMBERS";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_MODIFY_PROTECTED_PROPERTY)
			reason = "CANNOT_MODIFY_PROTECTED_PROPERTY";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_UPDATE_SUB_BASELINES)
			reason = "CANNOT_UPDATE_SUB_BASELINES";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_MODIFY_DESTINATION_CHECKED_IN_PARENT)
			reason = "CANNOT_MODIFY_DESTINATION_CHECKED_IN_PARENT";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_MOVE_WORKSPACE)
			reason = "CANNOT_MOVE_WORKSPACE";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_AUTO_CHECKOUT_CHECKIN)
			reason = "CANNOT_AUTO_CHECKOUT_CHECKIN";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_CREATE_NEW_BASELINE)
			reason = "CANNOT_CREATE_NEW_BASELINE";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_REMOVE_LABEL)
			reason = "CANNOT_REMOVE_LABEL";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_HAVE_LABEL_AND_APPLY_TO_VERSION)
			reason = "CANNOT_HAVE_LABEL_AND_APPLY_TO_VERSION";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_APPLY_TO_CHECKED_IN_VERSION)
			reason = "CANNOT_APPLY_TO_CHECKED_IN_VERSION";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_CREATE_VERSION)
			reason = "CANNOT_CREATE_VERSION";
		else if (exc.getReasonCode() == ReasonCode.BAD_REPORT)
			reason = "BAD_REPORT";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_UNBIND_RESOURCE)
			reason = "CANNOT_UNBIND_RESOURCE";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_CHECKIN_ACTIVITY)
			reason = "CANNOT_CHECKIN_ACTIVITY";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_INITIALIZE_UNRESERVED)
			reason = "CANNOT_INITIALIZE_UNRESERVED";
		else if (exc.getReasonCode() == ReasonCode.ILLEGAL_LOCATION_SYNTAX)
			reason = "ILLEGAL_LOCATION_SYNTAX";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_REFRESH_DIRTY_RESOURCE)
			reason = "CANNOT_REFRESH_DIRTY_RESOURCE";
		else if (exc.getReasonCode() == ReasonCode.MUST_NOT_BE_STALE)
			reason = "MUST_NOT_BE_STALE";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_SYNCHRONIZE_CONTENT)
			reason = "CANNOT_SYNCHRONIZE_CONTENT";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_INITIALIZE_RESOURCE)
			reason = "CANNOT_INITIALIZE_RESOURCE";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_READ_MEMBERS)
			reason = "CANNOT_READ_MEMBERS";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_UPDATE_SERVER_CONTENT)
			reason = "CANNOT_UPDATE_SERVER_CONTENT";
		else if (exc.getReasonCode() == ReasonCode.MULTIPLE_BINDINGS_NOT_ALLOWED)
			reason = "MULTIPLE_BINDINGS_NOT_ALLOWED";
		else if (exc.getReasonCode() == ReasonCode.NO_CROSS_SERVER_BINDING)
			reason = "NO_CROSS_SERVER_BINDING";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_OVERWRITE)
			reason = "CANNOT_OVERWRITE";
		else if (exc.getReasonCode() == ReasonCode.CYCLE_NOT_ALLOWED)
			reason = "CYCLE_NOT_ALLOWED";
		else if (exc.getReasonCode() == ReasonCode.CANNOT_CREATE_BINDING)
			reason = "CANNOT_CREATE_BINDING";
		else if (exc.getReasonCode() == ReasonCode.ACE_CONFLICT)
			reason = "ACE_CONFLICT";
		else if (exc.getReasonCode() == ReasonCode.DENY_BEFORE_GRANT)
			reason = "DENY_BEFORE_GRANT";
		else if (exc.getReasonCode() == ReasonCode.GRANT_ONLY)
			reason = "GRANT_ONLY";
		else if (exc.getReasonCode() == ReasonCode.PRIVILEGE_NOT_SUPPORTED)
			reason = "PRIVILEGE_NOT_SUPPORTED";
		else if (exc.getReasonCode() == ReasonCode.MISSING_REQUIRED_PRINCIPAL)
			reason = "MISSING_REQUIRED_PRINCIPAL";
		else if (exc.getReasonCode() == ReasonCode.PRINCIPAL_NOT_FOUND)
			reason = "PRINCIPAL_NOT_FOUND";
		else if (exc.getReasonCode() == ReasonCode.INVALID_PRINCIPAL)
			reason = "INVALID_PRINCIPAL";
		else
			reason = "UNKNOWN";
		
		return reason;
	}
}

