/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/wvcm/test/junit/src/org/apache/wvcm/test/common/util/XmlHelper.java,v 1.3 2004/07/30 06:52:35 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:35 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */


package org.apache.wvcm.test.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import org.custommonkey.xmlunit.DetailedDiff;
import org.custommonkey.xmlunit.Diff;
import org.xml.sax.InputSource;


/**
 * This class will provide some convenience methods for xml processing in the
 * test classes. It is intended to be a simple class, with no complex stuff.
 *
 * @author <a href="mailto:javier.gallego@softwareag.com">Javier Gallego</a>
 * @version $Revision: 1.3 $
 */
public class XmlHelper {
	
	/**
	 * Compares two xml strings. It does not include "\n" and "\t" in the
	 * comparison.
	 *
	 * @param    xmlRefString        First String to compare.
	 * @param    xmlString           The other String to compare.
	 *
	 * @return   True if both Strings are equal. False otherwise (hopefully).
	 *
	 */
	public boolean areXmlStringEqual(String xmlRefString, String xmlString) {
		String refString = xmlRefString.replaceAll("\n", "");
		refString = refString.replaceAll("\t", "");
		refString = refString.replaceAll("\r", "");
		refString = refString.replaceAll(" \\?>", "?>");
		
		String compString = xmlString.replaceAll("\n", "");
		compString = compString.replaceAll("\t", "");
		compString = compString.replaceAll("\r", "");
		compString = compString.replaceAll(" \\?>", "?>");
		
		return refString.equalsIgnoreCase(compString);
	}
	
	/**
	 * This method will compare the two xml files given in the parameters. Both
	 * given locations will be converted to URL and passed to the XMLUnit.
	 * If differences are there, these will be shown and the result passed on.
	 *
	 * @param    nsAware         	 If the check should be done being aware of
	 * namespaces.
	 * @param    locationURL         String representing a URL of an XML doc to
	 * compare.
	 * @param    locationFileSystem  String representing the absolute path to a
	 * file in the file system to compare.
	 *
	 * @return   a boolean True if both indicated files are equal. False if files
	 * are different or any other problem appeared.
	 *
	 */
	public boolean compareXML(String locationFileSystem,
							  ByteArrayOutputStream byteArrayToCompare) {
		boolean result = false;
		URL refURL;
		File refFile;
		InputSource compareInputSource;
		InputSource refInputSource;
		Diff diffTracker;
		DetailedDiff detailedDiff;
		ByteArrayInputStream byteArrayInputStream;
		try {
			byteArrayInputStream = new ByteArrayInputStream(byteArrayToCompare.toByteArray());
			compareInputSource = new InputSource(byteArrayInputStream);
			
			// Check if files to compare are there and are correct.
			refFile = new File(locationFileSystem);
			refURL = refFile.toURI().toURL();
			refInputSource = new InputSource(refURL.openStream());
			
			
			// Check for differences.
			diffTracker = new Diff(refInputSource, compareInputSource);
			detailedDiff = new DetailedDiff(diffTracker);
			
			if (diffTracker.identical()) {
				result = true;
			}
			else {
				System.out.println("DIFFERENCE FOUND WHILE COMPARING FILES:\n"
								   + detailedDiff.toString());
			}
		}
		catch (MalformedURLException e) {
			e.printStackTrace();
		}
		catch (Exception ex) {
			ex.printStackTrace();
		}
		return result;
	}
}

