/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/wvcm/test/junit/src/org/apache/wvcm/test/i18n/VersionTest.java,v 1.3 2004/07/30 06:52:36 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:36 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */

package org.apache.wvcm.test.i18n;
import java.util.List;

import javax.wvcm.ControllableResource;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Version;
import javax.wvcm.PropertyNameList.PropertyName;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.apache.wvcm.test.common.AbstractTest;

/**
 * Provide functional tests for javax.wvcm.Version
 *
 * @author <a href="mailto:peter.nevermann@softwareag.com">Peter Nevermann</a>
 * @version $Revision: 1.3 $
 */
public class VersionTest extends AbstractTest
{
	
	/**
	 * Default Constructor
	 *
	 * @param    testName            Name of the test to run.
	 *
	 * @throws   Exception
	 *
	 */
	public VersionTest(String testName) throws Exception
	{
		super(testName);
		resourcePath = rootFolderPath() + "/test.xml";
		folderPath = rootFolderPath() + "/foo";
		resourceInFolderPath = folderPath + "/test.xml";
		missingFolderPath = rootFolderPath() + "/bar";
		resourceInMissingFolderPath = rootFolderPath() + "/bar/test.xml";
	}
	
	/**
	 * Method suite
	 *
	 * @return   a Test
	 */
	public static Test suite()
	{
		return new TestSuite(VersionTest.class);
	}
	
	/**
	 * Start test suite contained in this class using the text interface. If a
	 * parameter is passed, it will use it as a test name and run only that test
	 * case.
	 *
	 * @param args   commandline options (first argument = test method name to run)
	 *
	 * @throws Exception
	 */
    public static void main( String[] args ) throws Exception
	{
		if (args.length == 1)
		{
			TestSuite testSuite = new TestSuite();
			testSuite.addTest(new VersionTest(args[0]));
			junit.textui.TestRunner.run(testSuite);
		}
		else
		{
			junit.textui.TestRunner.run( suite() );
		}
    }
	
	/**
	 * Common test setup.
	 *
	 * @throws Exception
	 */
	protected void setUp() throws Exception
	{
		super.setUp();
		// TODO: ADD CREATION OF RESOURCE AND ITS VERSION HISTORY. IT COULD GO HERE OR SEPARATELY.
	}
	
	/**
	 * Tears down the fixture, for example, close a network connection.
	 * This method is called after a test is executed.
	 *
	 * @throws Exception
	 */
	protected void tearDown() throws Exception
	{
	}
	
	/**
	 * <ul>
	 * <li>Create a test resource and put it under control.
	 * <li>Read property CHECKED_IN.
	 * <li>Check Version received.
	 * <li>Add, Remove and Set labels on the resource.
	 * <li>Check the label list of the version in each of the cases.
	 *
	 * @throws   Exception
	 *
	 */
	public void testDoI18nLabel() throws Exception
	{
		
		List labelList;
		
		String[] testLabels =
			new String[] { 	"\u00E0\u00E7\u00E8\u00E9\u00E4\u00F6\u00FC\u00C4\u00D6\u00DCutf8",
				"\u88FD\u54C1\u756A\u53F7utf8",
				"\u5373\u53EF\u986F\u793Autf8" };
		
		location = provider.location(resourcePath);
		resource = createControllableResource(location);
		resource.doControl();
		
		PropertyNameList wantedprops;
		PropertyName[] rPNames = { PropertyName.CHECKED_IN };
		wantedprops = new PropertyNameList(rPNames);
		resource = (ControllableResource)resource.doReadProperties(wantedprops);
		Version version = resource.getCheckedIn();
		assertTrue(
			"VERSION NUMBER UNEXPECTED.",
			version.location().string().endsWith("1.0"));
		
		PropertyName[] vPNames = { PropertyName.LABEL_NAME_LIST };
		wantedprops = new PropertyNameList(vPNames);
		version = (Version)version.doReadProperties(wantedprops);
		labelList = version.getLabelNameList();
		assertEquals("Unexpected size of Label list.", 0, labelList.size());
		
		// Add label alpha
		resource.doAddLabel(testLabels[0]);
		version = (Version)version.doReadProperties(wantedprops);
		labelList = version.getLabelNameList();
		assertEquals("Unexpected size of Label list.", 1, labelList.size());
		for (int i = 0; i < labelList.size(); i++)
		{
			assertEquals(
				"Unexpected label received.",
				testLabels[i],
				labelList.get(i));
		}
		
		// Add label omega
		resource.doAddLabel(testLabels[1]);
		version = (Version)version.doReadProperties(wantedprops);
		labelList = version.getLabelNameList();
		assertEquals("Unexpected size of Label list.", 2, labelList.size());
		for (int i = 0; i < labelList.size(); i++)
		{
			assertEquals(
				"Unexpected label received.",
				testLabels[i],
				labelList.get(i));

		}
		
		// remove label alpha
		resource.doRemoveLabel(testLabels[0]);
		version = (Version)version.doReadProperties(wantedprops);
		labelList = version.getLabelNameList();
		assertEquals("Unexpected size of Label list.", 1, labelList.size());
		
		assertEquals(
			"Unexpected label received.",
			testLabels[1],
			labelList.get(0));
		
		// Set label rc1
		resource.doSetLabel(testLabels[2]);
		version = (Version)version.doReadProperties(wantedprops);
		labelList = version.getLabelNameList();
		assertEquals("Unexpected size of Label list.", 2, labelList.size());
		
		for (int i = 0; i < labelList.size(); i++)
		{
			assertEquals(
				"Unexpected label received.",
				testLabels[i + 1],
				labelList.get(i));
		}
	}
	
	
}
