/*
 * $Header: /home/cvspublic/jakarta-slide/src/share/org/apache/slide/authenticate/SecurityToken.java,v 1.6 2004/07/28 09:38:45 ib Exp $
 * $Revision: 1.6 $
 * $Date: 2004/07/28 09:38:45 $
 *
 * ====================================================================
 *
 * Copyright 1999-2002 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */ 

package org.apache.slide.authenticate;

/**
 * Security token class.
 * 
 */
public final class SecurityToken {
    
    
    // ------------------------------------------------------------ Constructor
    
    
    /**
     * Constructor.
     * 
     * @param token Security Id stored in this token
     */
    public SecurityToken(Object token) {
        this.token = token;
    }
    
    // ----------------------------------------------------- Instance Variables
    
    
    /**
     * Security Id.
     * <p/>
     * May be a class name, or something different altogether.
     */
    private Object token;
    
    
    // ------------------------------------------------------------- Properties
    
    
    /**
     * Returns security token.
     * 
     * @return Object Security Id
     */
    public Object getToken() {
        return token;
    }
    
    
}
