/*
 * $Header: /home/cvspublic/jakarta-slide/src/share/org/apache/slide/common/DomainInitializationFailedError.java,v 1.6 2004/07/28 09:38:20 ib Exp $
 * $Revision: 1.6 $
 * $Date: 2004/07/28 09:38:20 $
 *
 * ====================================================================
 *
 * Copyright 1999-2002 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */ 

package org.apache.slide.common;

import org.apache.slide.util.Messages;

/**
 * Domain initialization failed.
 * 
 * @version $Revision: 1.6 $
 */
public class DomainInitializationFailedError extends SlideError {
    
    
    // ------------------------------------------------------------ Constructor
    
    
    /**
     * Constructor.
     */
    public DomainInitializationFailedError() {
        super(Messages.message
              (DomainInitializationFailedError.class.getName()));
    }
    
    
    /**
     * Constructor.
     * 
     * @param message Error mesage
     */
    public DomainInitializationFailedError(String message) {
        super(Messages.message(DomainInitializationFailedError.class.getName())
              + " : " + message);
    }
    
}
