package org.apache.slide.common;

import org.apache.slide.content.Content;
import org.apache.slide.lock.Lock;
import org.apache.slide.macro.Macro;
import org.apache.slide.search.Search;
import org.apache.slide.security.Security;
import org.apache.slide.structure.Structure;

/**
 * Interface for classes that provide access to Slide helper classes.
 */
public interface HelperProvider {
    /**
     * Get the data helper.
     *
     * @return Data Data helper
     */
    Structure getStructureHelper();
    
    
    /**
     * Get the version helper.
     *
     * @return Version Version helper
     */
    Content getContentHelper();
    
    
    /**
     * Get the lock helper.
     *
     * @return Lock Lock helper
     */
    Lock getLockHelper();
    
    
    /**
     * Get the lock helper.
     *
     * @return Lock Lock helper
     */
    Search getSearchHelper();
    
    
    /**
     * Get the security helper.
     *
     * @return Security Security helper
     */
    Security getSecurityHelper();
    
    
    /**
     * Get the macro helper.
     *
     * @return Macro Macro helper
     */
    Macro getMacroHelper();
}
