/*
 * $Header: /home/cvspublic/jakarta-slide/src/share/org/apache/slide/common/RequestedPropertyImpl.java,v 1.9 2005/01/10 18:17:28 luetzkendorf Exp $
 * $Revision: 1.9 $
 * $Date: 2005/01/10 18:17:28 $
 *
 * ====================================================================
 *
 * Copyright 1999-2002 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.slide.common;

import org.apache.slide.content.NodeProperty;

/**
 * Holds one property as part of the SELECT element.
 *
 * @version $Revision: 1.9 $
 */
public class RequestedPropertyImpl implements RequestedProperty {
    /** @deprecated this should be private. We should use PropertyName. */
    protected String namespace;
    private String name;
    private PropertyName propertyName;
    
	/**
	 * Constructs a RequestedProperty using the default namespace as defined
	 * in NodeProperty
	 *
	 * @param      propertyName the name of the property
	 */
    public RequestedPropertyImpl (String propertyName) {
		this.name = propertyName;
		this.namespace = NodeProperty.DEFAULT_NAMESPACE;
      this.propertyName = PropertyName.getPropertyName(this.name, this.namespace); 
    }
	
	/**
	 * Constructs a RequestedProperty:
	 *
	 * @param      propertyName the name of the property
	 * @param      namespace    the namespace of the property
	 */
    public RequestedPropertyImpl (String propertyName, String namespace) {
		this.name = propertyName;
		this.namespace    = namespace;
      this.propertyName = PropertyName.getPropertyName(this.name, this.namespace);
    }
	
    
    /**
	 * Method getPropertyName
	 *
	 * @return   the property's name
	 */
    public PropertyName getPropertyName() {
		return propertyName;
    }
    
    
    /**
	 * Method getNamespace
	 *
	 * @return   the property's namespace
	 */
    public String getNamespace() {
		return namespace;
    }

	/**
	 * Method getName
	 *
	 * @return   the name of the property
	 *
	 */
	public String getName() {
		return name;
	}

    /**
	 * checks, if another Object is equal to this RequestedProperty
	 *
	 * @param    o                   an Object
	 *
	 * @return   true if equal
	 */
    public boolean equals (Object o) {
		if (! (o instanceof RequestedProperty))
			return false;
        
		RequestedProperty other = (RequestedProperty)o;
		return this.propertyName.equals(other.getPropertyName());
    }
    
    /**
	 * debugging purpose
	 *
	 * @return   String representation of this RequestedProperty
	 */
    public String toString () {
		return namespace + name;
    }

    public int hashCode() {
        return this.propertyName.hashCode();
    }

}
