/*
 * $Header: /home/cvspublic/jakarta-slide/src/share/org/apache/slide/content/RevisionNotFoundException.java,v 1.7 2004/07/28 09:37:53 ib Exp $
 * $Revision: 1.7 $
 * $Date: 2004/07/28 09:37:53 $
 *
 * ====================================================================
 *
 * Copyright 1999-2002 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */ 

package org.apache.slide.content;

import org.apache.slide.util.Messages;

/**
 * Revision not found.
 * 
 * @version $Revision: 1.7 $
 */
public class RevisionNotFoundException extends ContentException {
    
    
    // ----------------------------------------------------------- Constructors
    
    
    /**
     * Constructor.
     * 
     * @param objectUri Uri of the object
     * @param number Number of the revision
     */
    public RevisionNotFoundException(String objectUri, 
                                     NodeRevisionNumber number) {
        super(Messages.format(RevisionNotFoundException.class.getName(), 
                              objectUri, number));
        this.objectUri = objectUri;
        this.number = number;
    }
    
    
    // ----------------------------------------------------- Instance Variables
    
    
    /**
     * Object Uri.
     */
    private String objectUri;
    

    /**
     * Revision Id.
     */
    private NodeRevisionNumber number;
    
    
    // ------------------------------------------------------------- Properties
    
    
    /**
     * Object Uri accessor.
     * 
     * @return String object Uri
     */
    public String getObjectUri() {
        if (objectUri == null) {
            return new String();
        } else {
            return objectUri;
        }
    }
    
    
    /**
     * Revision Id accessor.
     * 
     * @return NodeRevisionNumber
     */
    public NodeRevisionNumber getNumber() {
        return number;
    }
    
}
