/*
 * $Header: /home/cvspublic/jakarta-slide/src/share/org/apache/slide/event/DomainEvent.java,v 1.2 2005/03/29 08:01:17 luetzkendorf Exp $
 * $Revision: 1.2 $
 * $Date: 2005/03/29 08:01:17 $
 *
 * ====================================================================
 *
 * Copyright 2004 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.slide.event;

import java.util.EventListener;
import java.util.EventObject;

import org.apache.slide.common.Namespace;

/**
 * Events from the Slide Domain object.
 */
public class DomainEvent extends EventObject {

    public static final DomainInitialized DOMAIN_INITIALIZED = new DomainInitialized(); 
    public static final NamespaceInitialized NAMESPACE_INITIALIZED = new NamespaceInitialized();
    
    public final static String GROUP = "domain";
    public final static AbstractEventMethod[] methods = new AbstractEventMethod[] { DOMAIN_INITIALIZED, NAMESPACE_INITIALIZED };
    
    private Namespace namespace = null;
    
    public DomainEvent(Object source) {
        super(source);
    }
    public DomainEvent(Object source, Namespace namespace) {
        super(source);
        this.namespace = namespace;
    }
    
    public Namespace getNamespace() {
        return this.namespace;
    }
    
    public final static class DomainInitialized extends EventMethod {
        public DomainInitialized() {
            super(GROUP, "initialized");
        }

        public void fireEvent(EventListener listener, EventObject event) {
            if (listener instanceof DomainListener) {
                ((DomainListener)listener).initialized((DomainEvent)event);
            }
        }
    }
    
    public final static class NamespaceInitialized extends EventMethod {
        public NamespaceInitialized() {
            super(GROUP, "namepace-initialized");
        }

        public void fireEvent(EventListener listener, EventObject event) {
            if (listener instanceof DomainListener) {
                ((DomainListener)listener).namespaceInitialized((DomainEvent)event);
            }
        }
    }
}
