/*
 * $Header: /home/cvspublic/jakarta-slide/src/share/org/apache/slide/event/DomainListener.java,v 1.2 2005/03/29 08:01:17 luetzkendorf Exp $
 * $Revision: 1.2 $
 * $Date: 2005/03/29 08:01:17 $
 *
 * ====================================================================
 *
 * Copyright 2004 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.slide.event;

import java.util.EventListener;

/**
 * @author stefan
 */
public interface DomainListener extends EventListener {
    /**
     * Called if the Slide domain initialization has finished. 
     */
    public void initialized(DomainEvent event);
    
    /**
     * Called if the initialization of a slide namespace has just finished. 
     */
    public void namespaceInitialized(DomainEvent event);
}
