/*
 * $Header: /home/cvspublic/jakarta-slide/src/share/org/apache/slide/event/LockListener.java,v 1.3 2004/07/28 09:36:22 ib Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/28 09:36:22 $
 *
 * ====================================================================
 *
 * Copyright 2004 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.slide.event;

import java.util.EventListener;

/**
 * Lock listener interface
 *
 * @version $Revision: 1.3 $
 */
public interface LockListener extends EventListener {
    public void lock(LockEvent event) throws VetoException;

    public void unlock(LockEvent event) throws VetoException;

    public void renew(LockEvent event) throws VetoException;

    public void kill(LockEvent event) throws VetoException;
}