/*
 * $Header: /home/cvspublic/jakarta-slide/src/share/org/apache/slide/extractor/AbstractPropertyExtractor.java,v 1.5 2005/04/04 13:40:00 luetzkendorf Exp $
 * $Revision: 1.5 $
 * $Date: 2005/04/04 13:40:00 $
 *
 * ====================================================================
 *
 * Copyright 2004 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.slide.extractor;

import java.io.InputStream;
import java.util.Map;

/**
 * The AbstractPropertyExtractor class
 */
public abstract class AbstractPropertyExtractor implements PropertyExtractor {

    private String contentType;
    private String uri;
    private String namespace;

    public AbstractPropertyExtractor(String uri, String contentType) {
        this(uri, contentType, null);
    }

    public AbstractPropertyExtractor(String uri, String contentType, String namespace) {
        this.contentType = contentType;
        this.uri = uri;
        this.namespace = namespace;
    }

    public abstract Map extract(InputStream content) throws ExtractorException;

    /* (non-Javadoc)
     * @see org.apache.slide.extractor.Extractor#getContentType()
     */
    public String getContentType() {
        return contentType;
    }

    public String getUri() {
        return uri;
    }

    public String getNamespace() {
        return namespace;
    }
    
	/**
	 * Default implementation returns true if getContentType() contains the fileToIndexContentType<br/>
	 * OR if getContentType() returns null.
	 * @param fileToIndexContentType The content type of the file we want to index.
	 */
	public boolean isAcceptableContentType(String fileToIndexContentType) {
		if (fileToIndexContentType == null || fileToIndexContentType.length() == 0) {
			return false;
		}
		if(getContentType() != null){
			//return true if the contentType string contains fileToIndexContentType
			return (getContentType().indexOf(fileToIndexContentType)>=0);
		}
		return true;
	}

}
