/*
 * $Header: /home/cvspublic/jakarta-slide/src/share/org/apache/slide/extractor/Extractor.java,v 1.6 2005/01/14 18:34:13 luetzkendorf Exp $
 * $Revision: 1.6 $
 * $Date: 2005/01/14 18:34:13 $
 *
 * ====================================================================
 *
 * Copyright 2004 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.slide.extractor;

/**
 * The Extractor interface.<br/>
 * Default init parameters in Domain.xml include:<br/>
 * <li>"classname" - The extractor class.</li>
 * <li>"uri" - The URI the extractor handles.</li>
 * <li>"content-type" - A comma separated list of supported content types</li>
 * <li>"namespace" - The namespace the extractor handles.</li>
 */
public interface Extractor {

	/**
	 * @param contentType of the file to index
	 * @return true if this extractor can handle indexing a file of the supplied contentType otherwise false.
	 */
    public boolean isAcceptableContentType(String contentType);

    /**
     * @return a comma separated list of content types this extractor is registered to handle.<br/>
     * May return null also if it handles any type of file.
     */
    public String getContentType();
    
    /**
     * @return The URI this extractor is registered to handle.
     */
    public String getUri();

    /**
     * @return The namespace this extractor is registered to handle.
     */
    public String getNamespace();

}
