/*
 * $Header: /home/cvspublic/jakarta-slide/src/share/org/apache/slide/lock/ObjectIsAlreadyLockedException.java,v 1.8 2004/07/28 09:35:44 ib Exp $
 * $Revision: 1.8 $
 * $Date: 2004/07/28 09:35:44 $
 *
 * ====================================================================
 *
 * Copyright 1999-2002 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */ 

package org.apache.slide.lock;

import org.apache.slide.common.NestedSlideException;
import org.apache.slide.util.Messages;

/**
 * Object is already locked.
 * 
 * @version $Revision: 1.8 $
 */
public class ObjectIsAlreadyLockedException extends NestedSlideException {
    
    
    // ----------------------------------------------------------- Constructors
    
    
    /**
     * Constructor.
     * 
     * @param objectUri Uri of the locked object
     */
    public ObjectIsAlreadyLockedException(String objectUri) {
        super(Messages.format(ObjectIsAlreadyLockedException.class.getName(), 
                              objectUri));
    }

    
}
