/*
 * $Header: /home/cvspublic/jakarta-slide/src/share/org/apache/slide/search/basic/IBasicResultSet.java,v 1.3 2004/07/28 09:35:01 ib Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/28 09:35:01 $
 *
 * ====================================================================
 *
 * Copyright 1999 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.slide.search.basic;

// import list
import java.util.Set;

/**
 * This Set is returned by {@link org.apache.slide.search.basic.IBasicExpression#execute
 * IBasicExpression.execute()}. It extends {@link java.util.Set Set} by method
 * {@link #isPartialResultSet isPartialResultSet()}.
 *
 * @version $Revision: 1.3 $
 *
 **/
public interface IBasicResultSet extends Set {
    
    /**
     * Returns <code>true</code> if the result set is truncated for any reason.
     *
     * @return     <code>true</code> if the result set is truncated for any reason.
     */
    public boolean isPartialResultSet();
}

