/*
 * $Header: /home/cvspublic/jakarta-slide/src/share/org/apache/slide/search/basic/expression/GenericBasicExpression.java,v 1.5 2004/11/29 18:46:51 luetzkendorf Exp $
 * $Revision: 1.5 $
 * $Date: 2004/11/29 18:46:51 $
 *
 * ====================================================================
 *
 * Copyright 2002-2004 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.slide.search.basic.expression;

import org.apache.slide.search.InvalidQueryException;
import org.apache.slide.search.basic.ComparableResourcesPool;
import org.jdom.Element;

/**
 * GenericBasicExpression.java
 *
 */

public abstract class GenericBasicExpression extends BasicExpression {

    
    /**
     * constructor. Only called by the conrecte expressions
     *
     * @param e                       the jdom element representing this expression.
     */
    protected GenericBasicExpression (Element e) throws InvalidQueryException{
        super (e);
    }
    
    public abstract void setRequestedResourcePool(ComparableResourcesPool pool);
            
}

