// vi: set ts=3 sw=3:
package org.apache.slide.search.basic.expression;

import org.apache.slide.common.SlideException;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.search.InvalidQueryException;
import org.apache.slide.search.basic.ComparableResource;
import org.apache.slide.search.basic.ComparableResourcesPool;
import org.apache.slide.search.basic.Literals;
import org.jdom.Element;


/**
 * Implements the <code>not-like</code> operator.
 */
public class NotLikeExpression extends LikeExpression
{

    public NotLikeExpression(Element e,
            ComparableResourcesPool requestedResourcesPool)
            throws InvalidQueryException
    {
        super(e, requestedResourcesPool);
    }
    
    protected boolean compare(ComparableResource item)
    {
        try {
            NodeProperty value = item.getProperty(
                    comparedProperty.getProperty(),
                    comparedProperty.getPropNamespace());
            if (value != null) {
                return !wildcardEquals(
                        comparedProperty.getLiteral(),
                        0,
                        value.getValue().toString(),
                        0);
            }
        } catch (SlideException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } 
        return false;
    }
    
    public String toString () {
        return super.toString(Literals.NOT_LIKE);
    }

}
