/*
 * $Header: /home/cvspublic/jakarta-slide/src/share/org/apache/slide/security/UnauthenticatedException.java,v 1.1 2005/02/09 19:08:05 ozeigermann Exp $
 * $Revision: 1.1 $
 * $Date: 2005/02/09 19:08:05 $
 *
 * ====================================================================
 *
 * Copyright 2004 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.slide.security;

/**
 * Exception that indicates a user has not correctly authenticated itself, but should have. 
 * When this exception gets caught by the WebDAV layer it will request client authentication.
 */
public class UnauthenticatedException extends SecurityException {

    public UnauthenticatedException(String user) {
        super("User " + user + " has not been authenticated");
    }

}