/*
 * $Header: /home/cvspublic/jakarta-slide/src/share/org/apache/slide/store/ConcurrencyConflictError.java,v 1.1 2004/12/15 16:50:34 ozeigermann Exp $
 * $Revision: 1.1 $
 * $Date: 2004/12/15 16:50:34 $
 *
 * ====================================================================
 *
 * Copyright 1999-2002 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.slide.store;

import java.sql.SQLException;

/**
 * Error gets thrown from the store layer upon failure caused by
 * other concurrent requests. Such failures include deadlocks, unserializable
 * transactions and other spurious behaviour caused by insufficient isolation.
 *
 * <em>Note:</em> This must be an error to ensure it passes the store layer and 
 * gets caught in the WebDAV layer only
 *
 * @version $Revision: 1.1 $
 */
public class ConcurrencyConflictError extends Error {
    
    protected int errorCode;
    protected String uri;
    
    public ConcurrencyConflictError(int errorCode, String message, String uri) {
        super(message);
        this.errorCode = errorCode;
        this.uri = uri;
    }

    public ConcurrencyConflictError(SQLException e, String uri) {
        this(e.getErrorCode(), e.getMessage(), uri);
    }

    public ConcurrencyConflictError() {
        this(-1, "Conflict Exception", null);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        
        if (uri != null) {
            buf.append(uri).append(": ");
        }
        if (getMessage() != null) {
            buf.append(getMessage());
        }
        if (errorCode != -1) {
            buf.append("(").append(errorCode).append(")");
        }
        return buf.toString();
    }
    /**
     * @return Returns the errorCode.
     */
    public int getErrorCode() {
        return errorCode;
    }
    /**
     * @return Returns the uri.
     */
    public String getUri() {
        return uri;
    }
}
