/*
 * $Header: /home/cvspublic/jakarta-slide/src/share/org/apache/slide/store/RevisionDescriptorStore.java,v 1.7 2004/07/28 09:34:41 ib Exp $
 * $Revision: 1.7 $
 * $Date: 2004/07/28 09:34:41 $
 *
 * ====================================================================
 *
 * Copyright 1999-2002 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */ 

package org.apache.slide.store;

import org.apache.slide.common.Service;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.Uri;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.content.RevisionDescriptorNotFoundException;

/**
 * Store for RevisionDescriptor objects.
 * 
 * @version $Revision: 1.7 $
 */
public interface RevisionDescriptorStore extends Service {
    
    
    // ------------------------------------------------------ Interface Methods
    
    
    /**
     * Retrieve an individual object's revision descriptor.
     * 
     * @param uri uri
     * @param revisionNumber Node revision number
     */
    NodeRevisionDescriptor retrieveRevisionDescriptor
        (Uri uri, NodeRevisionNumber revisionNumber)
        throws ServiceAccessException, RevisionDescriptorNotFoundException;
    
    
    /**
     * Create a new revision descriptor.
     * 
     * @param uri Uri
     * @param revisionDescriptor Node revision descriptor
     * @exception ServiceAccessException Service access error
     */
    void createRevisionDescriptor(Uri uri, 
                                  NodeRevisionDescriptor revisionDescriptor)
        throws ServiceAccessException;
    
    
    /**
     * Update a revision descriptor.
     * 
     * @param uri Uri
     * @param revisionDescriptor Node revision descriptor
     * @exception ServiceAccessException Service access error
     * @exception RevisionDescriptorNotFoundException Revision descriptor 
     * was not found
     */
    void storeRevisionDescriptor(Uri uri, 
                                 NodeRevisionDescriptor revisionDescriptor)
        throws ServiceAccessException, RevisionDescriptorNotFoundException;
    
    
    /**
     * Remove a revision descriptor.
     * 
     * @param uri Uri
     * @param revisionNumber Revision number
     * @exception ServiceAccessException Service access error
     */
    void removeRevisionDescriptor(Uri uri, NodeRevisionNumber revisionNumber)
        throws ServiceAccessException;
    
}
