/*
 * $Header: /home/cvspublic/jakarta-slide/src/stores/org/apache/slide/index/lucene/expressions/ContainsExpression.java,v 1.3 2004/12/07 17:49:57 luetzkendorf Exp $
 * $Revision: 1.3 $
 * $Date: 2004/12/07 17:49:57 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.slide.index.lucene.expressions;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;

import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;

import org.apache.slide.index.lucene.Index;
import org.apache.slide.index.lucene.IndexConfiguration;
import org.apache.slide.search.BadQueryException;
import org.jdom.Element;

/**
 * Implements the <code>contains</code> expression.
 */
public class ContainsExpression extends AbstractLuceneExpression
{

    public ContainsExpression(Index index, Element element, boolean negated)
            throws BadQueryException
    {
        super(index);

        IndexConfiguration config = index.getConfiguration();
        String literal = element.getText();

        int starPos = literal.indexOf('*');
        int qmPos = literal.indexOf('?');
        if (starPos != -1 || qmPos != -1) {
            if (starPos == literal.length()-1 && qmPos == -1) {
                // some thing like "word*"
                // TODO the .toLowerCase() should depend from the Analyzer
                setQuery(new PrefixQuery(new Term(Index.CONTENT_FIELD_NAME, 
                        literal.substring(0, literal.length()-1).toLowerCase())));
            } else {
                // TODO dito
                setQuery(new WildcardQuery(new Term(Index.CONTENT_FIELD_NAME, literal.toLowerCase())));
            }
        } else {
            termOrPhraseQuery(config, Index.CONTENT_FIELD_NAME, literal);
        }
        
        // TODO
        if (negated) {
            setQuery(negateQuery(getQuery()));
        }
    }

    private void termOrPhraseQuery(IndexConfiguration config, String field, String text)
    {
        TokenStream ts = config.getAnalyzer().tokenStream(field,
                new StringReader(text));

        ArrayList tokens = new ArrayList(20);
        try {
            for (Token t = ts.next(); t != null; t = ts.next()) {
                tokens.add(t.termText());
            }
        } catch (IOException e) {
            // should not happen, because we are reading from StringReader
        }
        
        if (tokens.size() > 1) {
            PhraseQuery phraseQuery = new PhraseQuery();
            for(int i = 0, l = tokens.size(); i<l; i++) {
                phraseQuery.add(new Term(field, (String)tokens.get(i)));
            }
            setQuery(phraseQuery);
        } else if (tokens.size() == 1) {
            setQuery(new TermQuery(new Term(field, (String)tokens.get(0))));
        } else {
            // TODO NOP query???
            setQuery(new BooleanQuery());
        }
    }
}
