/*
 * $Header: /home/cvspublic/jakarta-slide/src/stores/org/apache/slide/index/lucene/expressions/EqExpression.java,v 1.5 2004/11/29 18:38:16 luetzkendorf Exp $
 * $Revision: 1.5 $
 * $Date: 2004/11/29 18:38:16 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.slide.index.lucene.expressions;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.TermQuery;

import org.apache.slide.index.lucene.Index;
import org.apache.slide.index.lucene.IndexConfiguration;
import org.apache.slide.search.BadQueryException;
import org.jdom.Element;

/**
 * Implements <code>eq</code> and <code>not-eq</code>.
 */
public class EqExpression extends AbstractLuceneExpression
{

    public EqExpression(Index index, Element element, boolean negated)
        throws BadQueryException
    {
        super(index);
        
        IndexConfiguration config = index.getConfiguration();
        Element prop = getPropertyElement(element);
        String field = config.generateFieldName(prop.getNamespaceURI(), prop.getName());
        Element literal = getLiteralElement(element);

        String value;
        if (index.getConfiguration().isDateProperty(prop.getNamespaceURI(), prop.getName())) {
            value = config.dateToIndexString(IndexConfiguration.getDateValue(literal.getTextTrim()));
        } 
        else if (index.getConfiguration().isIntProperty(prop.getNamespaceURI(), prop.getName())) { 
            value = config.intToIndexString(Long.parseLong(literal.getTextTrim()));
        } 
        else {
            value = literal.getTextTrim();
        }
        
        Term term = new Term(field, value);
        
        setQuery(new TermQuery(term));

        if (negated) {
            BooleanQuery booleanQuery = new BooleanQuery();
            booleanQuery.add(
                    new TermQuery(new Term(Index.IS_DEFINED_FIELD_NAME, field)),
                    true, false);
            booleanQuery.add(getQuery(),
                    false, true);
            setQuery(booleanQuery);
        }
    }
}
