/*
 * $Header: /home/cvspublic/jakarta-slide/src/stores/org/apache/slide/index/lucene/expressions/IsCollectionExpression.java,v 1.4 2004/12/07 17:49:57 luetzkendorf Exp $
 * $Revision: 1.4 $
 * $Date: 2004/12/07 17:49:57 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.slide.index.lucene.expressions;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.TermQuery;

import org.apache.slide.content.NodeProperty;
import org.apache.slide.index.lucene.Index;
import org.apache.slide.index.lucene.IndexConfiguration;

/**
 * Implements the <code>is-collection</code> and the <code>not-is-collection</code>
 * expression. 
 */
public class IsCollectionExpression extends AbstractLuceneExpression
{
    public IsCollectionExpression(Index index, boolean negated)
    {
        super(index);
        
        IndexConfiguration config = index.getConfiguration();
        setQuery(new TermQuery(new Term(config.generateFieldName(
                NodeProperty.DEFAULT_NAMESPACE, "resourcetype"),
                "collection")));

        if (negated) {
            setQuery(negateQuery(getQuery()));
        }
    }
}
