/*
 * $Header: /home/cvspublic/jakarta-slide/src/stores/org/apache/slide/index/lucene/expressions/IsDefinedExpression.java,v 1.6 2004/12/07 17:49:57 luetzkendorf Exp $
 * $Revision: 1.6 $
 * $Date: 2004/12/07 17:49:57 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.slide.index.lucene.expressions;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.TermQuery;

import org.apache.slide.index.lucene.Index;
import org.apache.slide.index.lucene.IndexConfiguration;
import org.apache.slide.search.BadQueryException;
import org.jdom.Element;


/**
 * Implements the <code>is-defined</code> and the <code>not-is-defined</code>
 * expression.
 */
public class IsDefinedExpression extends AbstractLuceneExpression
{
    public IsDefinedExpression(Index index, Element element, boolean negated) 
        throws BadQueryException
    {
        super(index);

        IndexConfiguration config = index.getConfiguration();
        Element prop = getPropertyElement(element);
        String field = config.generateFieldName(prop.getNamespaceURI(), prop.getName());
        
        setQuery(new TermQuery(new Term(Index.IS_DEFINED_FIELD_NAME, field)));
        if (negated) {
            setQuery(negateQuery(getQuery()));
        }
    }
    
    public IsDefinedExpression(Index index, String field, boolean negated) {
        super(index);

        setQuery(new TermQuery(new Term(Index.IS_DEFINED_FIELD_NAME, field)));
        if (negated) {
            setQuery(negateQuery(getQuery()));
        }
    }
}
