/*
 * $Header: /home/cvspublic/jakarta-slide/src/stores/org/apache/slide/index/lucene/expressions/LikeExpression.java,v 1.5 2004/12/07 17:49:57 luetzkendorf Exp $
 * $Revision: 1.5 $
 * $Date: 2004/12/07 17:49:57 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.slide.index.lucene.expressions;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.search.WildcardTermEnum;

import org.apache.slide.index.lucene.Index;
import org.apache.slide.index.lucene.IndexConfiguration;
import org.apache.slide.search.BadQueryException;
import org.jdom.Element;


/**
 * Implements the <code>like</code> operator.
 * 
 */
public class LikeExpression extends AbstractLuceneExpression
{

    public LikeExpression(Index index, Element element, boolean negated) 
        throws BadQueryException
    {
        super(index);
        
        IndexConfiguration config = index.getConfiguration();
        Element prop = getPropertyElement(element);
        String field = config.generateFieldName(prop.getNamespaceURI(), prop.getName());
        Element literal = getLiteralElement(element);
        String text = literal.getTextTrim();
        
        // TODO check what to do with Date or Int fields
        
        if (text.indexOf('_') == -1 && text.indexOf('%') == text.length()-1) {
            // some thing line "apple%"
            setQuery(new PrefixQuery(new Term(field, 
                    text.substring(0, text.length()-1))));
        } else {
            setQuery(new WildcardQuery(new Term(field, 
                    transformQuerytext(text))));
        }
        
        if (negated) {
            BooleanQuery booleanQuery = new BooleanQuery();
            booleanQuery.add(
                    new TermQuery(new Term(Index.IS_DEFINED_FIELD_NAME, field)),
                    true, // required
                    false);
            booleanQuery.add(getQuery(),
                    false, 
                    true); // prohibited
            setQuery(booleanQuery);
        }
    }
    
    private String transformQuerytext(String text)
            throws BadQueryException
    {
        
        StringBuffer result = new StringBuffer(text.length());
        
        for(int i = 0, l = text.length(); i<l; i++) {
            char c = text.charAt(i);
            switch(c) {
                case '%':
                    result.append(WildcardTermEnum.WILDCARD_STRING);
                    break;
                case '_':
                    result.append(WildcardTermEnum.WILDCARD_CHAR);
                    break;
                default:
                    result.append(c);
            }
        }
        
        return result.toString();
    }
    
    public static void main(String[] a) {
        System.out.println("abc".indexOf("c"));
        System.out.println("abc".substring(0, "abc".length()-1));
    }

}
