/*
 * $Header: /home/cvspublic/jakarta-slide/src/stores/org/apache/slide/index/lucene/expressions/PropcontainsExpression.java,v 1.5 2004/12/07 17:49:57 luetzkendorf Exp $
 * $Revision: 1.5 $
 * $Date: 2004/12/07 17:49:57 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.slide.index.lucene.expressions;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;

import org.apache.slide.index.lucene.Index;
import org.apache.slide.index.lucene.IndexConfiguration;
import org.apache.slide.search.BadQueryException;
import org.jdom.Element;


/**
 * Implements the <code>propcontains</code> operator. 
 * 
 * <p>This expression is actually a <code>substring</code> expression.  
 * 
 */
public class PropcontainsExpression extends AbstractLuceneExpression
{

    public PropcontainsExpression(Index index, Element element, boolean negated) 
        throws BadQueryException
    {
        super(index);
        
        IndexConfiguration config = index.getConfiguration();
        Element prop = getPropertyElement(element);
        String field = config.generateFieldName(prop.getNamespaceURI(), prop.getName());
        Element literal = getLiteralElement(element);
        String text = literal.getTextTrim();
        
        setQuery(new WildcardQuery(new Term(field, "*" + text + "*")));
        
        if (negated) {
            BooleanQuery booleanQuery = new BooleanQuery();
            booleanQuery.add(
                    new TermQuery(new Term(Index.IS_DEFINED_FIELD_NAME, field)),
                    true,  // required 
                    false);
            booleanQuery.add(getQuery(),
                    false, 
                    true); // prohibited
            setQuery(booleanQuery);
        }
    }
}
