/*
 * $Header: /home/cvspublic/jakarta-slide/src/stores/org/apache/slide/store/file/SimpleFileStoreTest.java,v 1.1 2004/09/20 07:56:38 ozeigermann Exp $
 * $Revision: 1.1 $
 * $Date: 2004/09/20 07:56:38 $
 *
 * ====================================================================
 *
 * Copyright 1999-2002 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.slide.store.file;

import java.io.*;
import org.apache.commons.logging.*;
import org.apache.slide.common.*;
import org.apache.slide.content.*;
import org.apache.slide.structure.*;
import org.apache.slide.authenticate.*;
import junit.framework.*;

/**
 * @author Alon Salant
 */
public class SimpleFileStoreTest
      extends TestCase
{
  private static final Log log = LogFactory.getLog(SimpleFileStoreTest.class);

  Domain domain;
  NamespaceAccessToken namespace;

  public SimpleFileStoreTest(String s)
  {
      super(s);
  }

  public void setUp() throws Exception
  {
    Domain.init(new FileInputStream("WEB-INF/properties/TestDomain.xml"));
    namespace = Domain.accessNamespace(null, "slide");
  }

  public void tearDown() throws Exception
  {

  }

  public void testCreateFile() throws Exception
  {
    String path = "/test.txt";
    File file = new File("files/test.txt");
    try
    {
      SlideToken token = new SlideTokenWrapper(new SlideTokenImpl());
      token.setForceSecurity(false);
      token.setForceLock(false);
      token.setCredentialsToken(new CredentialsToken(""));

      Content content = namespace.getContentHelper();
      Structure structure = namespace.getStructureHelper();

      structure.create(token, new SubjectNode(), path);

      assertTrue(file.exists());
      assertTrue(file.isDirectory());

      NodeRevisionContent newContent = new NodeRevisionContent();
      newContent.setContent("delete me, please".getBytes());
      content.create(token, path, new NodeRevisionDescriptor(), newContent);

      NodeRevisionContent createdContent = content.retrieve(token, path, new NodeRevisionDescriptor());
      assertNotNull(createdContent);
      assertEquals(new String(newContent.getContent()), new String(createdContent.getContent()));
    }
    finally
    {
      if (file.exists()) file.delete();
    }
  }
}
