/*
 * $Header: /home/cvspublic/jakarta-slide/src/stores/org/apache/slide/store/impl/rdbms/MySql41RDBMSAdapter.java,v 1.5 2004/11/29 18:40:03 luetzkendorf Exp $
 * $Revision: 1.5 $
 * $Date: 2004/11/29 18:40:03 $
 *
 * ====================================================================
 *
 * Copyright 1999-2003 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.slide.store.impl.rdbms;


import org.apache.slide.common.Service;
import org.apache.slide.util.logger.Logger;

/**
 * Adapter for MySQL 4.1. DELETE semantics are somewhat deviant
 * from MySQL 4.0. Table names should be referred to by their alias.
 * 
 */
public class MySql41RDBMSAdapter extends MySqlRDBMSAdapter {

  /**
   * @param service
   * @param logger
   */
  public MySql41RDBMSAdapter(Service service, Logger logger) {
    super(service, logger);
  }

  /**
   * Permits varying delete semantics between different db's or even db versions.
   * @param table name of table from which to delete
   * @param alias alias of table from which to delete
   * @param sql delete statement starting with " where" for single table and ", tablename" for multiple table delete
   * @return Delete statement in correct SQL dialect
   */
  protected String deleteStatement(String table, String alias, String sql) {
    return "delete " + alias + " from " + table + " " + alias + sql;
  }

}