/*
 * $Header: /home/cvspublic/jakarta-slide/src/stores/org/apache/slide/store/ojb/LoggerBridge.java,v 1.1 2005/01/02 20:25:53 ozeigermann Exp $
 * $Revision: 1.1 $
 * $Date: 2005/01/02 20:25:53 $
 *
 * ====================================================================
 *
 * Copyright 1999-2002 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.slide.store.ojb;

import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.slide.util.logger.Logger;
import org.apache.slide.common.Domain;

/**
 * This class allows OJB to use the Slide logging system.
 * To use set the LoggerClass parameter in OJB-logging.properties
 * to this class.
 */
public class LoggerBridge implements org.apache.ojb.broker.util.logging.Logger {

    private static Logger logger;
    private String name;
    private static int[] levelArray;
    
    static {
        // FATAL is OJB's highest level 
        levelArray = new int[FATAL+1];
        levelArray[DEBUG] = Logger.DEBUG;
        levelArray[INFO] = Logger.INFO;
        levelArray[WARN] = Logger.WARNING;
        levelArray[ERROR] = Logger.ERROR;
        levelArray[FATAL] = Logger.CRITICAL;
    }
    
    public LoggerBridge(String name) {
        this.name = name;
    }
    
    public static void setLogger(Logger slideLogger) {
        logger = slideLogger;
    }
    
    public static Logger getLogger() {
        return logger;
    }
    
    private void log(Object data, int level) {
        if ( logger != null )
            logger.log(data, name, level);
        else
            Domain.log(data, name, level);
    }
    
    private void log(Object data, Throwable t, int level) {
         if ( logger != null )
            logger.log(data, t, name, level);
        else
            Domain.log(data, name, level);
    }
    
    public void debug(Object data) {
        log(data, Logger.DEBUG);
    }

    public void info(Object data) {
        log(data, Logger.INFO);
    }

    public void warn(Object data) {
        log(data, Logger.WARNING);
    }

    public void error(Object data) {
        log(data, Logger.ERROR);
    }

    public void fatal(Object data) {
        log(data, Logger.CRITICAL);
    }

    public void debug(Object data, Throwable t) {
        log(data, t, Logger.DEBUG);
    }

    public void info(Object data, Throwable t) {
        log(data, t, Logger.INFO);
    }

    public void warn(Object data, Throwable t) {
        log(data, t, Logger.WARNING);
    }

    public void error(Object data, Throwable t) {
        log(data, t, Logger.ERROR);
    }

    public void fatal(Object data, Throwable t) {
        log(data, t, Logger.CRITICAL);
    }

    public boolean isEnabledFor(int level) {
        if ( logger != null )
            return logger.isEnabled(name, levelArray[level]);
        else
            return Domain.isEnabled(name, levelArray[level]);
    }

    public boolean isDebugEnabled() {
        if ( logger != null )
            return logger.isEnabled(name, Logger.DEBUG);
        else
            return Domain.isEnabled(name, Logger.DEBUG);
    }

    public String getName() {
         return name;
    }

    public void safeDebug(String message, Object data) {
        log(message, Logger.DEBUG);
    }

    public void safeDebug(String message, Object data, Throwable t) {
        log(message, t, Logger.DEBUG);
    }

    public void safeInfo(String message, Object data) {
        log(message, Logger.INFO);
    }

    public void safeInfo(String message, Object data, Throwable t) {
        log(message, t, Logger.INFO);
    }

    public void safeWarn(String message, Object data) {
        log(message, Logger.WARNING);
    }

    public void safeWarn(String message, Object data, Throwable t) {
        log(message, t, Logger.WARNING);
    }

    public void safeError(String message, Object data) {
        log(message, Logger.ERROR);
    }

    public void safeError(String message, Object data, Throwable t) {
        log(message, t, Logger.ERROR);
    }

    public void safeFatal(String message, Object data) {
        log(message, Logger.CRITICAL);
    }

    public void safeFatal(String message, Object data, Throwable t) {
        log(message, t, Logger.CRITICAL);
    }

    public void configure(Configuration config) throws ConfigurationException {
        // not needed, configure Slide logging instead
    }

}
