/*
 * $Header: /home/cvspublic/jakarta-slide/src/stores/org/apache/slide/store/ojb/peer/BranchPeer.java,v 1.3 2005/01/23 13:57:27 cvillegas Exp $
 * $Revision: 1.3 $
 * $Date: 2005/01/23 13:57:27 $
 *
 * ====================================================================
 *
 * Copyright 1999-2002 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.slide.store.ojb.peer;

import java.io.Serializable;

/**
 * @ojb.class table="${table.prefix}BRANCH"
 * 
 * @ojb.index name="${table.prefix}BRANCH_STRING_IDX"
 *            unique="true"
 *            fields="branchString"
 * 
 */
public class BranchPeer implements Serializable {

    /**
     * @ojb.field column="BRANCH_ID"
     *            primarykey="true"
     *            autoincrement="ojb"
     */
    private long branchId;
    
    /**
     * @ojb.field column="BRANCH_STRING"
     *            length="255"
     */
    private String branchString;
    
    /**
     * @return Returns the branchId.
     */
    public long getBranchId() {
        return branchId;
    }
    /**
     * @param branchId The branchId to set.
     */
    public void setBranchId(long branchId) {
        this.branchId = branchId;
    }
    /**
     * @return Returns the branchString.
     */
    public String getBranchString() {
        return branchString;
    }
    /**
     * @param branchString The branchString to set.
     */
    public void setBranchString(String branchString) {
        this.branchString = branchString;
    }
}
