/*
 * $Header: /home/cvspublic/jakarta-slide/src/stores/org/apache/slide/store/ojb/peer/LockPeer.java,v 1.3 2005/01/23 13:57:27 cvillegas Exp $
 * $Revision: 1.3 $
 * $Date: 2005/01/23 13:57:27 $
 *
 * ====================================================================
 *
 * Copyright 1999-2002 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.slide.store.ojb.peer;

import java.io.Serializable;
import java.util.Date;

/**
 * @ojb.class table="${table.prefix}LOCKS"
 *
 */
public class LockPeer implements Serializable {

    /**
     * @ojb.field column="LOCK_ID"
     *            primarykey="true"
     */
    private long lockId;
    
    /**
     * @ojb.field column="OBJECT_ID"
     */
    private long objectId;
    
    /**
     * @ojb.field column="SUBJECT_ID"
     */
    private long subjectId;
    
    /**
     * @ojb.field column="TYPE_ID"
     */
    private long typeId;
    
    /**
     * @ojb.field column="OWNER"
     *            length="255"
     */
    private String owner;
    
    /**
     * @ojb.field column="IS_INHERITABLE"
     */
    private boolean inheritable;
    
    /**
     * @ojb.field column="IS_EXCLUSIVE"
     */
    private boolean exclusive;
    
    /**
     * @ojb.field column="EXPIRATION_DATE"
     *            jdbc-type="TIMESTAMP"
     *            conversion="org.apache.ojb.broker.accesslayer.conversions.JavaDate2SqlTimestampFieldConversion"
     */
    private Date expirationDate;
    
    /**
     * @ojb.reference foreignkey="lockId"
     */
    private UriPeer lockUri;
    
    /**
     * @ojb.reference foreignkey="objectId"
     */
    private UriPeer objectUri;
    
    /**
     * @ojb.reference foreignkey="subjectId"
     */
    private UriPeer subjectUri;
    
    /**
     * @ojb.reference foreignkey="typeId"
     */
    private UriPeer typeUri;
    
    /**
     * @return Returns the exclusive.
     */
    public boolean isExclusive() {
        return exclusive;
    }
    /**
     * @param exclusive The exclusive to set.
     */
    public void setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
    }
    /**
     * @return Returns the expirationDate.
     */
    public Date getExpirationDate() {
        return expirationDate;
    }
    /**
     * @param expirationDate The expirationDate to set.
     */
    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }
    /**
     * @return Returns the inheritable.
     */
    public boolean isInheritable() {
        return inheritable;
    }
    /**
     * @param inheritable The inheritable to set.
     */
    public void setInheritable(boolean inheritable) {
        this.inheritable = inheritable;
    }
    /**
     * @return Returns the lockId.
     */
    public long getLockId() {
        return lockId;
    }
    /**
     * @param lockId The lockId to set.
     */
    public void setLockId(long lockId) {
        this.lockId = lockId;
    }
    /**
     * @return Returns the objectId.
     */
    public long getObjectId() {
        return objectId;
    }
    /**
     * @param objectId The objectId to set.
     */
    public void setObjectId(long objectId) {
        this.objectId = objectId;
    }
    /**
     * @return Returns the objectUri.
     */
    public UriPeer getObjectUri() {
        return objectUri;
    }
    /**
     * @param objectUri The objectUri to set.
     */
    public void setObjectUri(UriPeer objectUri) {
        this.objectUri = objectUri;
    }
    /**
     * @return Returns the owner.
     */
    public String getOwner() {
        return owner;
    }
    /**
     * @param owner The owner to set.
     */
    public void setOwner(String owner) {
        this.owner = owner;
    }
    /**
     * @return Returns the subjectId.
     */
    public long getSubjectId() {
        return subjectId;
    }
    /**
     * @param subjectId The subjectId to set.
     */
    public void setSubjectId(long subjectId) {
        this.subjectId = subjectId;
    }
    /**
     * @return Returns the subjectUri.
     */
    public UriPeer getSubjectUri() {
        return subjectUri;
    }
    /**
     * @param subjectUri The subjectUri to set.
     */
    public void setSubjectUri(UriPeer subjectUri) {
        this.subjectUri = subjectUri;
    }
    /**
     * @return Returns the typeId.
     */
    public long getTypeId() {
        return typeId;
    }
    /**
     * @param typeId The typeId to set.
     */
    public void setTypeId(long typeId) {
        this.typeId = typeId;
    }
    /**
     * @return Returns the typeUri.
     */
    public UriPeer getTypeUri() {
        return typeUri;
    }
    /**
     * @param typeUri The typeUri to set.
     */
    public void setTypeUri(UriPeer typeUri) {
        this.typeUri = typeUri;
    }
    /**
     * @return Returns the lockUri.
     */
    public UriPeer getLockUri() {
        return lockUri;
    }
    /**
     * @param lockUri The lockUri to set.
     */
    public void setLockUri(UriPeer lockUri) {
        this.lockUri = lockUri;
    }
}
