/*
 * $Header: /home/cvspublic/jakarta-slide/src/stores/org/apache/slide/store/ojb/peer/ObjectPeer.java,v 1.3 2005/01/23 13:57:27 cvillegas Exp $
 * $Revision: 1.3 $
 * $Date: 2005/01/23 13:57:27 $
 *
 * ====================================================================
 *
 * Copyright 1999-2002 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.slide.store.ojb.peer;

import java.io.Serializable;
import java.util.Collection;

/**
 * @ojb.class table="${table.prefix}OBJECT"
 *
 */
public class ObjectPeer implements Serializable {
    
    /**
     * @ojb.field column="URI_ID"
     *            primarykey="true"
     */
    private long uriId;
    
    /**
     * @ojb.field column="CLASS_NAME"
     *            length="255"
     */
    private String className;

    /**
     * @ojb.reference foreignkey="uriId"
     */
    private UriPeer uri;

    /**
     * @ojb.collection element-class-ref="org.apache.slide.store.ojb.peer.BindingPeer"
     *                 foreignkey="uriId"
     */
    private Collection bindings;

    /**
     * @ojb.collection element-class-ref="org.apache.slide.store.ojb.peer.ParentBindingPeer"
     *                 foreignkey="uriId"
     */    
    private Collection parentBindings;
    
    /**
     * The collection of all link nodes that point to this object node.
     * 
     * @ojb.collection element-class-ref="org.apache.slide.store.ojb.peer.UriPeer"
     *                 indirection-table="${table.prefix}LINKS"
     *                 foreignkey="URI_ID"
     *                 remote-foreignkey="LINK_TO_ID"
     */    
    private Collection links;
    
    /**
     * @return Returns the uriId.
     */
    public long getUriId() {
        return uriId;
    }
    
    /**
     * @param uriId The uriId to set.
     */
    public void setUriId(long uriId) {
        this.uriId = uriId;
    }
    
    /**
     * @return Returns the className
     */
    public String getClassName() {
        return className;
    }
    
    /**
     * @param className The className to set.
     */
    public void setClassName(String className) {
        this.className = className;
    }

    /**
     * Get the <code>Uri</code> value.
     *
     * @return an <code>UriPeer</code> value
     */
    public UriPeer getUri() {
        return uri;
    }

    /**
     * Set the <code>Uri</code> value.
     *
     * @param newUri The new Uri value.
     */
    public void setUri(UriPeer newUri) {
        this.uri = newUri;
    }
    
    /**
     * @return Returns the bindings.
     */
    public Collection getBindings() {
        return bindings;
    }
    
    /**
     * @param bindings The bindings to set.
     */
    public void setBindings(Collection bindings) {
        this.bindings = bindings;
    }
    
    /**
     * @return Returns the links.
     */
    public Collection getLinks() {
        return links;
    }
    
    /**
     * @param links The links to set.
     */
    public void setLinks(Collection links) {
        this.links = links;
    }
    
    /**
     * @return Returns the parentBindings.
     */
    public Collection getParentBindings() {
        return parentBindings;
    }
    
    /**
     * @param parentBindings The parentBindings to set.
     */
    public void setParentBindings(Collection parentBindings) {
        this.parentBindings = parentBindings;
    }
}
