/*
 * $Header: /home/cvspublic/jakarta-slide/src/stores/org/apache/slide/store/ojb/peer/ParentBindingPeer.java,v 1.3 2005/01/23 13:57:27 cvillegas Exp $
 * $Revision: 1.3 $
 * $Date: 2005/01/23 13:57:27 $
 *
 * ====================================================================
 *
 * Copyright 1999-2002 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.slide.store.ojb.peer;

import java.io.Serializable;

/**
 * @ojb.class table="${table.prefix}PARENT_BINDING"
 *
 */
public class ParentBindingPeer implements Serializable {

    /**
     * @ojb.field column="URI_ID"
     *            primarykey="true"
     */
    private long uriId;
    
    /**
     * @ojb.field column="NAME"
     *            length="255"
     *            primarykey="true"
     */
    private String name;
    
    /**
     * @ojb.field column="PARENT_UURI_ID"
     *            primarykey="true"

     */
    private long parentUuriId;
    
    /**
     * @ojb.reference foreignkey="uriId"
     */
    private UriPeer uri;
    
    /**
     * @ojb.reference foreignkey="parentUuriId"
     *                auto-retrieve="true"
     */
    private UriPeer parentUuri;
    
    
    /**
     * @return Returns the name.
     */
    public String getName() {
        return name;
    }
    /**
     * @param name The name to set.
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * @return Returns the parentUuri.
     */
    public UriPeer getParentUuri() {
        return parentUuri;
    }
    /**
     * @param parentUuri The parentUuri to set.
     */
    public void setParentUuri(UriPeer parentUuri) {
        this.parentUuri = parentUuri;
    }
    /**
     * @return Returns the parentUuriId.
     */
    public long getParentUuriId() {
        return parentUuriId;
    }
    /**
     * @param parentUuriId The parentUuriId to set.
     */
    public void setParentUuriId(long parentUuriId) {
        this.parentUuriId = parentUuriId;
    }
    /**
     * @return Returns the uri.
     */
    public UriPeer getUri() {
        return uri;
    }
    /**
     * @param uri The uri to set.
     */
    public void setUri(UriPeer uri) {
        this.uri = uri;
    }
    /**
     * @return Returns the uriId.
     */
    public long getUriId() {
        return uriId;
    }
    /**
     * @param uriId The uriId to set.
     */
    public void setUriId(long uriId) {
        this.uriId = uriId;
    }
}
