/*
 * $Header: /home/cvspublic/jakarta-slide/src/stores/org/apache/slide/store/ojb/peer/PermissionPeer.java,v 1.3 2005/01/23 13:57:27 cvillegas Exp $
 * $Revision: 1.3 $
 * $Date: 2005/01/23 13:57:27 $
 *
 * ====================================================================
 *
 * Copyright 1999-2002 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.slide.store.ojb.peer;

import java.io.Serializable;

/**
 * @ojb.class table="${table.prefix}PERMISSIONS"
 *
 * @ojb.index name="${table.prefix}PERMISSIONS_SUCCESSION_IDX"
 *            unique="true"
 *            fields="objectId,succession"
 */
public class PermissionPeer implements Serializable {

    /**
     * @ojb.field column="OBJECT_ID"
     *            primarykey="true"
     */
    private long objectId;
    
    /**
     * @ojb.field column="SUBJECT_ID"
     *            primarykey="true"
     */
    private long subjectId;
    
    /**
     * @ojb.field column="ACTION_ID"
     *            primarykey="true"
     */
    private long actionId;
    
    /**
     * @ojb.field column="VERSION_NO"
     *            length="32"
     */
    private String versionNumber;
    
    /**
     * @ojb.field column="IS_INHERITABLE"
     */
    private boolean inheritable;
    
    /**
     * @ojb.field column="IS_NEGATIVE"
     */
    private boolean negative;
    
    /**
     * @ojb.field column="SUCCESSION"
     */
    private int succession;
    
    /**
     * @ojb.reference foreignkey="objectId"
     */
    private UriPeer objectUri;
    
    /**
     * @ojb.reference foreignkey="subjectId"
     */
    private UriPeer subjectUri;
    
    /**
     * @ojb.reference foreignkey="actionId"
     */
    private UriPeer actionUri;
    
    /**
     * @return Returns the actionId.
     */
    public long getActionId() {
        return actionId;
    }
    /**
     * @param actionId The actionId to set.
     */
    public void setActionId(long actionId) {
        this.actionId = actionId;
    }
    /**
     * @return Returns the actionUri.
     */
    public UriPeer getActionUri() {
        return actionUri;
    }
    /**
     * @param actionUri The actionUri to set.
     */
    public void setActionUri(UriPeer actionUri) {
        this.actionUri = actionUri;
    }
    /**
     * @return Returns the inheritable.
     */
    public boolean isInheritable() {
        return inheritable;
    }
    /**
     * @param inheritable The inheritable to set.
     */
    public void setInheritable(boolean inheritable) {
        this.inheritable = inheritable;
    }
    /**
     * @return Returns the negative.
     */
    public boolean isNegative() {
        return negative;
    }
    /**
     * @param negative The negative to set.
     */
    public void setNegative(boolean negative) {
        this.negative = negative;
    }
    /**
     * @return Returns the objectId.
     */
    public long getObjectId() {
        return objectId;
    }
    /**
     * @param objectId The objectId to set.
     */
    public void setObjectId(long objectId) {
        this.objectId = objectId;
    }
    /**
     * @return Returns the objectUri.
     */
    public UriPeer getObjectUri() {
        return objectUri;
    }
    /**
     * @param objectUri The objectUri to set.
     */
    public void setObjectUri(UriPeer objectUri) {
        this.objectUri = objectUri;
    }
    /**
     * @return Returns the subjectId.
     */
    public long getSubjectId() {
        return subjectId;
    }
    /**
     * @param subjectId The subjectId to set.
     */
    public void setSubjectId(long subjectId) {
        this.subjectId = subjectId;
    }
    /**
     * @return Returns the subjectUri.
     */
    public UriPeer getSubjectUri() {
        return subjectUri;
    }
    /**
     * @param subjectUri The subjectUri to set.
     */
    public void setSubjectUri(UriPeer subjectUri) {
        this.subjectUri = subjectUri;
    }
    /**
     * @return Returns the succession.
     */
    public int getSuccession() {
        return succession;
    }
    /**
     * @param succession The succession to set.
     */
    public void setSuccession(int succession) {
        this.succession = succession;
    }
    /**
     * @return Returns the versionNumber.
     */
    public String getVersionNumber() {
        return versionNumber;
    }
    /**
     * @param versionNumber The versionNumber to set.
     */
    public void setVersionNumber(String versionNumber) {
        this.versionNumber = versionNumber;
    }
}
