/*
 * $Header: /home/cvspublic/jakarta-slide/src/stores/org/apache/slide/store/ojb/peer/PropertyPeer.java,v 1.3 2005/01/23 13:57:27 cvillegas Exp $
 * $Revision: 1.3 $
 * $Date: 2005/01/23 13:57:27 $
 *
 * ====================================================================
 *
 * Copyright 1999-2002 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.slide.store.ojb.peer;

import java.io.Serializable;

/**
 * @ojb.class table="${table.prefix}PROPERTIES"
 * 
 * @ojb.index name="${table.prefix}PROPERTIES_IDX"
 *            unique="true"
 *            fields="versionId,namespace,name"
 *
 */
public class PropertyPeer implements Serializable {

    /**
     * @ojb.field column="PROPERTY_ID"
     *            primarykey="true"
     *            autoincrement="ojb"
     */
    private long propertyId;
    
    /**
     * @ojb.field column="VERSION_ID"
     */
    private long versionId;
    
    /**
     * @ojb.field column="PROPERTY_NAMESPACE"
     *            length="64"
     */
    private String namespace;
    
    /**
     * @ojb.field column="PROPERTY_NAME"
     *            length="64"
     */
    private String name;
    
    /**
     * @ojb.field column="PROPERTY_VALUE"
     *            jdbc-type="LONGVARCHAR"
     *            length="4000"
     */
    private String value;
    
    /**
     * @ojb.field column="PROPERTY_TYPE"
     *            length="64"
     */
    private String type;
    
    /**
     * @ojb.field column="IS_PROTECTED"
     * 
     * use this name since 'protected' gives problems with reflection
     */
    private boolean propertyProtected;
    
    /**
     * @ojb.reference foreignkey="versionId"
     */
    private VersionHistoryPeer versionHistory;
    
    /**
     * @return Returns the propertyId.
     */
    public long getPropertyId() {
        return propertyId;
    }
    /**
     * @param propertyId The propertyId to set.
     */
    public void setPropertyId(long propertyId) {
        this.propertyId = propertyId;
    }
    
    /**
     *
     * 
     * @return Returns the isProtected.
     */
    public boolean isPropertyProtected() {
        return propertyProtected;
    }
    /**
     * @param isProtected The isProtected to set.
     */
    public void setPropertyProtected(boolean isProtected) {
        this.propertyProtected = isProtected;
    }
    /**
     * @return Returns the name.
     */
    public String getName() {
        return name;
    }
    /**
     * @param name The name to set.
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * @return Returns the namespace.
     */
    public String getNamespace() {
        return namespace;
    }
    /**
     * @param namespace The namespace to set.
     */
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }
    /**
     * @return Returns the type.
     */
    public String getType() {
        return type;
    }
    /**
     * @param type The type to set.
     */
    public void setType(String type) {
        this.type = type;
    }
    /**
     * @return Returns the value.
     */
    public String getValue() {
        return value;
    }
    /**
     * @param value The value to set.
     */
    public void setValue(String value) {
        this.value = value;
    }
    /**
     * @return Returns the versionId.
     */
    public long getVersionId() {
        return versionId;
    }
    /**
     * @param versionId The versionId to set.
     */
    public void setVersionId(long versionId) {
        this.versionId = versionId;
    }
    /**
     * @return Returns the versionHistory.
     */
    public VersionHistoryPeer getVersionHistory() {
        return versionHistory;
    }
    /**
     * @param versionHistory The versionHistory to set.
     */
    public void setVersionHistory(VersionHistoryPeer versionHistory) {
        this.versionHistory = versionHistory;
    }
}
