/*
 * $Header: /home/cvspublic/jakarta-slide/src/stores/org/apache/slide/store/ojb/peer/PropertyValuePeer.java,v 1.2 2005/01/23 13:57:27 cvillegas Exp $
 * $Revision: 1.2 $
 * $Date: 2005/01/23 13:57:27 $
 *
 * ====================================================================
 *
 * Copyright 1999-2002 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.slide.store.ojb.peer;

import java.io.Serializable;

/**
 * @ojb.class table="${table.prefix}PROPERTY_VALUES"
 *
 */
public class PropertyValuePeer implements Serializable {
    
    /**
     * @ojb.field column="PROPERTY_ID"
     *            primarykey="true"
     *
     */
    private long propertyId;
    
    /**
     * @ojb.field column="VALUE_ID"
     *            primarykey="true"
     */
    private long valueId;
    
    /**
     * @ojb.field column="PROPERTY_VALUE"
     *            jdbc-type="LONGVARCHAR"
     *            length="4000"
     */
    private String value;
    
    /**
     * @ojb.reference foreignkey="propertyId"
     */
    private PropertyPeer property;
    
    /**
     * @return Returns the valueId.
     */
    public long getValueId() {
        return valueId;
    }
    /**
     * @param valueId The valueId to set.
     */
    public void setValueId(long valueId) {
        this.valueId = valueId;
    }
    /**
     * @return Returns the property.
     */
    public PropertyPeer getProperty() {
        return property;
    }
    /**
     * @param property The property to set.
     */
    public void setProperty(PropertyPeer property) {
        this.property = property;
    }
    /**
     * @return Returns the propertyId.
     */
    public long getPropertyId() {
        return propertyId;
    }
    /**
     * @param propertyId The propertyId to set.
     */
    public void setPropertyId(long propertyId) {
        this.propertyId = propertyId;
    }
    /**
     * @return Returns the value.
     */
    public String getValue() {
        return value;
    }
    /**
     * @param value The value to set.
     */
    public void setValue(String value) {
        this.value = value;
    }
}
