/*
 * $Header: /home/cvspublic/jakarta-slide/src/stores/org/apache/slide/store/ojb/peer/UriPeer.java,v 1.3 2005/01/23 13:57:27 cvillegas Exp $
 * $Revision: 1.3 $
 * $Date: 2005/01/23 13:57:27 $
 *
 * ====================================================================
 *
 * Copyright 1999-2002 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.slide.store.ojb.peer;

import java.io.Serializable;

/**
 * @ojb.class table="${table.prefix}URI"
 *
 * @ojb.index name="${table.prefix}URI_STRING_IDX"
 *            unique="true"
 *            fields="uriString"
 * 
 */
public class UriPeer implements Serializable {
    
    /**
     * @ojb.field column="URI_ID"
     *            primarykey="true"
     *            autoincrement="ojb"
     */
    private long uriId;
    
    /**
     * @ojb.field column="URI_STRING"
     *            jdbc-type="LONGVARCHAR"
     *            length="2500"
     */
    private String uriString;
    
    /**
     * @return Returns the uriId.
     */
    public long getUriId() {
        return uriId;
    }
    /**
     * @param uriId The uriId to set.
     */
    public void setUriId(long uriId) {
        this.uriId = uriId;
    }
    /**
     * @return Returns the uriString.
     */
    public String getUriString() {
        return uriString;
    }
    /**
     * @param uriString The uriString to set.
     */
    public void setUriString(String uriString) {
        this.uriString = uriString;
    }
}
